% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-child-count}
\alias{node-child-count}
\alias{node_child_count}
\alias{node_named_child_count}
\title{Get a node's child count}
\usage{
node_child_count(x)

node_named_child_count(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
A single integer, the number of children of \code{x}.
}
\description{
These functions return the number of children of \code{x}.
\itemize{
\item \code{node_child_count()} considers both named and anonymous children.
\item \code{node_named_child_count()} considers only named children.
}
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Navigate to first child
node <- node_child(node, 1)
node

# Note how the named variant doesn't count the anonymous operator node
node_child_count(node)
node_named_child_count(node)
\dontshow{\}) # examplesIf}
}
