\name{trc_m_search}
\alias{trc_m_search}
\title{
Procedure for the choice of m for the TRC tau}
\usage{
trc_m_search(X,Y,start=3,range_m=0.8,span=0.3)
}
\arguments{
  \item{X}{An observed data vector from the first condition.}

  \item{Y}{An observed data vector from the second condition.}

  \item{start}{A lower bound of a search region for the threshold rank m (default: 3).}
  
  \item{range_m}{A proportion of length of X for specifying the end of the search region for m
  (default: 0.8).}
    
  \item{span}{A parameter alpha which controls the degree of smoothing in loess function.}
}

\value{
  \item{tau}{A calculated TRC tau value with the chosen m value (chs_m).}
  \item{chs_m}{the chosen m value.}
  \item{km_tau_vec}{A vector of calculated k_m * TRC tau values for the given values of m [start, floor(range_m*n)]}
  \item{km_tau_loess}{A fitted values by the local regression with loess function for km_tau_vec .}
  
}
\description{
 Procedure for the choice of m for the TRC tau.
}

\details{
The thresholding rank m is chosen by
the proposed procedure in Lim et al. (2019).
}

\references{
Lim, J., Yu, D., Kuo, H., Choi, H., and Walmsely, S. (2019).
Truncated Rank Correlation as a robust
measure of test-retest reliability
in mass spectrometry data. Statistical Applications in Genetics and Molecular Biology, 18(4).
}

\examples{
%
p = 100
sig_z = 1.15
sig_e = 1
mu_z = 2
mu_e = 8
m0 = 30

S1 = rnorm(p,mean=mu_e,sd=sig_e)
S2 = rnorm(p,mean=mu_e,sd=sig_e)
    
if(m0!=0)
{
   X = mu_z + rnorm(m0,mean=0,sd=sig_z)
   indx = 1:p
   s_indx = sort(sample(indx,m0))
   S1[s_indx] = S1[s_indx] + X
   S2[s_indx] = S2[s_indx] + X
}
      
S1 = exp(S1)
S2 = exp(S2)

# tau_m
trc_res = trc_m_search(S1,S2,start=3,range_m=0.8,span=0.2)
trc_res$tau
trc_res$chs_m

}

