% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_validate.R
\name{toon_peek}
\alias{toon_peek}
\title{Peek at TOON file structure}
\usage{
toon_peek(file, n = 50L, allow_comments = TRUE)
}
\arguments{
\item{file}{Character scalar. Path to TOON file.}

\item{n}{Integer. Number of lines to preview (default 50).}

\item{allow_comments}{Logical. If TRUE (default), allow comments.}
}
\value{
A list with components:
\itemize{
\item type: Character. Top-level type ("object", "array", "tabular_array", "unknown").
\item first_keys: Character vector. First few keys if top-level is object.
\item preview: Character vector. First n lines.
}
}
\description{
Peek at TOON file structure
}
\examples{
\dontrun{
info <- toon_peek("data.toon")
cat("Type:", info$type, "\n")
cat("Preview:\n", info$preview, sep = "\n")
}

}
