% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_core.R
\name{to_toon}
\alias{to_toon}
\title{Serialize R object to TOON}
\usage{
to_toon(x, pretty = TRUE, indent = 2L, strict = TRUE, allow_comments = FALSE)
}
\arguments{
\item{x}{R object to serialize.}

\item{pretty}{Logical. If TRUE (default), use multi-line formatting.}

\item{indent}{Integer. Number of spaces for indentation (default 2).}

\item{strict}{Logical. If TRUE (default), reject NaN/Inf values.}

\item{allow_comments}{Logical. For future use (writers generally should not
emit comments).}
}
\value{
Character scalar with class "toon" containing the TOON representation.
}
\description{
Serialize R object to TOON
}
\details{
Type conversions:
\itemize{
\item factor -> character
\item Date -> ISO 8601 string (YYYY-MM-DD)
\item POSIXct -> ISO 8601 string (YYYY-MM-DDTHH:MM:SSZ)
\item NA values -> null
}
}
\examples{
# Serialize simple list
to_toon(list(name = "Alice", age = 30))

# Serialize vector
to_toon(c(1, 2, 3))

# Compact format
to_toon(list(x = 1, y = 2), pretty = FALSE)

}
