% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales-coltab.R
\name{scale_coltab}
\alias{scale_coltab}
\alias{scale_fill_coltab}
\alias{scale_colour_coltab}
\alias{get_coltab_pal}
\title{Discrete scales based in the color table of a \code{SpatRaster}}
\usage{
scale_fill_coltab(
  data,
  ...,
  alpha = NA,
  na.translate = FALSE,
  na.value = "transparent",
  drop = TRUE
)

scale_colour_coltab(
  data,
  ...,
  alpha = NA,
  na.translate = FALSE,
  na.value = "transparent",
  drop = TRUE
)

get_coltab_pal(x)
}
\arguments{
\item{data, x}{A \code{SpatRaster} with one or several color tables.
See \code{\link[terra:colors]{terra::has.colors()}}.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}
  \describe{
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (none for discrete, one minor break
between each major break for continuous)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
break positions.
}}
    \item{\code{labels}}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
  }}

\item{alpha}{The alpha transparency: could be \code{NA} or a number in [0,1].
See argument \code{alpha} in \code{\link[=scale_fill_terrain_d]{scale_fill_terrain_d()}}.}

\item{na.translate}{Should \code{NA} values be removed from the legend? Default
is \code{TRUE}.}

\item{na.value}{Missing values will be replaced with this value. By default,
\CRANpkg{tidyterra} uses \code{na.value = "transparent"} so cells with \code{NA} are
not filled. See also
\href{https://github.com/dieghernan/tidyterra/issues/120}{#120}.}

\item{drop}{Should unused factor levels be omitted from the scale? The
default (\code{TRUE}) removes unused factors.}
}
\value{
The corresponding \CRANpkg{ggplot2} layer with the values applied to the
\code{fill/colour} aesthetics.
}
\description{
Some categorical \code{SpatRaster} objects may have an associated color table.
This function extract those values. These functions generates scales and
vector of colors based on the color table \code{\link[terra:colors]{terra::coltab()}} associated to a
\code{SpatRaster}.

You can also get a vector of colors named with the corresponding
factor with \code{\link[=get_coltab_pal]{get_coltab_pal()}}.

Additional arguments \code{...} would be passed on to
\code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.

\strong{Note that} \CRANpkg{tidyterra} just documents a selection of these
additional arguments, check \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}} to see the full
range of arguments accepted.
}
\examples{
library(terra)
# Geological Eras
# Spanish Geological Survey (IGME)

r <- rast(system.file("extdata/cyl_era.tif", package = "tidyterra"))

plot(r)

# Get coltab
coltab_pal <- get_coltab_pal(r)

coltab_pal

\donttest{
# With ggplot2 + tidyterra
library(ggplot2)

gg <- ggplot() +
  geom_spatraster(data = r)


# Default plot
gg

# With coltabs
gg +
  scale_fill_coltab(data = r)
}
}
\seealso{
\code{\link[terra:colors]{terra::coltab()}}, \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}},
\code{\link[ggplot2:scale_manual]{ggplot2::scale_fill_manual()}},
}
