% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_grid}
\alias{expand_grid}
\title{Create a tibble from all combinations of inputs}
\usage{
expand_grid(..., .name_repair = "check_unique", .vary = "slowest")
}
\arguments{
\item{...}{Name-value pairs. The name will become the column name in the
output.}

\item{.name_repair}{One of \code{"check_unique"}, \code{"unique"}, \code{"universal"},
\code{"minimal"}, \code{"unique_quiet"}, or \code{"universal_quiet"}. See \code{\link[vctrs:vec_as_names]{vec_as_names()}}
for the meaning of these options.}

\item{.vary}{One of:
\itemize{
\item \code{"slowest"} to vary the first column slowest. This produces sorted
output and is generally the most useful.
\item \code{"fastest"} to vary the first column fastest. This matches the behavior
of \code{\link[=expand.grid]{expand.grid()}}.
}}
}
\value{
A tibble with one column for each input in \code{...}. The output will
have one row for each combination of the inputs, i.e. the size will be
equal to the product of the sizes of the inputs. This implies that if any
input has length 0, the output will have zero rows. The ordering of the
output depends on the \code{.vary} argument.
}
\description{
\code{expand_grid()} is heavily motivated by \code{\link[=expand.grid]{expand.grid()}}.
Compared to \code{expand.grid()}, it:
\itemize{
\item Produces sorted output by varying the first column the slowest by default.
\item Returns a tibble, not a data frame.
\item Never converts strings to factors.
\item Does not add any additional attributes.
\item Can expand any generalised vector, including data frames.
}
}
\examples{
# Default behavior varies the first column "slowest"
expand_grid(x = 1:3, y = 1:2)

# Vary the first column "fastest", like `expand.grid()`
expand_grid(x = 1:3, y = 1:2, .vary = "fastest")

# Can also expand data frames
expand_grid(df = tibble(x = 1:2, y = c(2, 1)), z = 1:3)

# And matrices
expand_grid(x1 = matrix(1:4, nrow = 2), x2 = matrix(5:8, nrow = 2))
}
