% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_diagnostics.R
\name{ild_diagnostics}
\alias{ild_diagnostics}
\title{Residual diagnostics for an ILD model}
\usage{
ild_diagnostics(object, data = NULL, by_id = TRUE, ...)
}
\arguments{
\item{object}{A fitted model from [ild_lme()] (or an object with
`residuals()`, and optional `fitted()`; if not `ild_lme`, pass `data` with
`.ild_id` and `.ild_time_num` or `.ild_seq`).}

\item{data}{Optional. ILD data (required if `object` is not from [ild_lme()]).}

\item{by_id}{Logical. If `TRUE`, compute ACF within each person (default `TRUE`).}

\item{...}{Unused.}
}
\value{
A list with: `acf` (ACF values or list by id), `residuals`, `fitted`,
  `id`, `time` (or `seq`), `ar1_param` (if applicable), and `plot` (a ggplot or list of plots).
}
\description{
Computes residual ACF (by person and/or pooled), residual vs fitted,
residual vs time, and optional Q-Q. For `ild_lme` models with `ar1 = TRUE`,
reports the estimated AR/CAR parameter.
}
