% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_calls.R
\name{compare_calls}
\alias{compare_calls}
\title{Comparision between multiple tidy variants or genotypes.}
\usage{
compare_calls(td, dest_file = FALSE, creads = FALSE)
}
\arguments{
\item{td}{List of named tidy dataframes with at least 'sample',
'locus', 'sequence'.}

\item{dest_file}{Path to EXCEL file to write results. Default (FALSE),
no file is written.}

\item{creads}{Account for reads. dataframes in 'td' must have 'reads'
column with the
number of reads supporting each variant. If FALSE (default)
distances between calls
and plots are produced on the basis of presence (1)/absense (0) of
the variant.
If TRUE, read count are accounted for estimating distances and producing
the plots. Default (FALSE).}
}
\value{
A list of 4 elements:
\itemize{
\item \emph{tidy_dat}: combined tidy number of reads for all elements in 'td'. If
'creads = FALSE', cells are coded as '1' (presence) and '0' (absence).
\item \emph{variants}: list with dataframes in wide format with all variants as
columns.
Variants are named 'locus_\{first 6 characters of md5 of DNA seq\}'.
Zeroes '0'
are included where no variant was found. If
'creads = FALSE', cells are coded as '1' (presence) and '0' (absence)
\item \emph{comp}: T/F matrix. samples x variants. TRUE, the cell\emph{ij} across all
matrices has the same value; FALSE, any of them has a different value.
\item \emph{dist}: pairwise distances between matrices (analogue to Manhattan
distance).
\item \emph{plot1}: heatmap with frequency of calls (>1 == 1) across elements
compared.
\item \emph{plot2}: heatmap with calls for all elements compared.
Black tiles indicate calls absent in the element but present in another.
element.
\item \emph{plot3}: boxplot of reads ordered by frecuency.
(output only if 'creads' == TRUE).
\item \emph{plot4}: MDS plot (output only when length(td) > 2).
\item (it writes an EXCEL file with the results to 'dest_file'.)
}
}
\description{
Comparision between multiple tidy variants or genotypes.
}
\examples{
data("variant_calls")
compare_calls(variant_calls, creads = TRUE)
}
