% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_insights.R
\name{display_row_frmts}
\alias{display_row_frmts}
\title{Display formatting applied to each row}
\usage{
display_row_frmts(tfrmt, .data, convert_to_txt = TRUE)
}
\arguments{
\item{tfrmt}{tfrmt object to apply to the data}

\item{.data}{Data to apply the tfrmt to}

\item{convert_to_txt}{Logical value converting formatting to text, by default
\code{TRUE}}
}
\value{
formatted tibble
}
\description{
Used when debugging formatting, it is an easy way to allow you to see which
formats are applied to each row in your dataset.
}
\examples{
 library(dplyr)
 library(tidyr)

 tfrmt_spec <- tfrmt(
 label = label,
 column = column,
 param = param,
 value=value,
 body_plan = body_plan(
   frmt_structure(group_val = ".default", label_val = ".default",
                  frmt_combine(
                    "{count} {percent}",
                    count = frmt("xxx"),
                    percent = frmt_when("==100"~ frmt(""),
                                        "==0"~ "",
                                        "TRUE" ~ frmt("(xx.x\%)"))))
 ))

 # Create data
 df <- tidyr::crossing(label = c("label 1", "label 2"),
                column = c("placebo", "trt1"),
                param = c("count", "percent")) |>
   dplyr::mutate(value=c(24,19,2400/48,1900/38,5,1,500/48,100/38))

 display_row_frmts(tfrmt_spec,df)
}
