% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyfunctions.R
\name{.read_qsm_raw}
\alias{.read_qsm_raw}
\title{Read a PyTLidar QSM file}
\usage{
.read_qsm_raw(cyl_file)
}
\arguments{
\item{cyl_file}{Path to the PyTLidar cylinder output file (.txt).}
}
\value{
A data frame with columns startX, startY, startZ, endX, endY, endZ,
  cyl_ID, parent_ID, extension_ID, radius_cyl, length, volume, branching_order.
}
\description{
Reads a PyTLidar-generated cylinder file and converts it into a tidy data frame
with start/end coordinates, radius, length, volume, and branching order.
}
