\name{translate}
\alias{translate}
\title{Interactive Translation Tool for Sumerian Text}
\description{
Opens an interactive Shiny gadget for translating a single line of Sumerian cuneiform text. The page displays four sections on a single scrollable page: n-gram patterns, context with neighbouring lines, grammar probabilities, and an interactive skeleton with dictionary lookup. When the user clicks \dQuote{Done}, the function returns a \code{\link{skeleton}} object with the translations.
}
\usage{
translate(x, text = NULL, dic = NULL, mapping = NULL, fill = NULL,
          min_freq = c(6, 4, 2), sentence_prob = 1.0)
}
\arguments{
  \item{x}{A single Sumerian text string (transliteration, sign names, or cuneiform), or an integer line number indexing into \code{text}.}
  \item{text}{A character vector containing the full text being translated (one line per element), a file path to load with \code{readLines()}, or \code{NULL}. Lines may start with numbering like \code{"12)\t..."} or \code{"12. ..."}. Required when \code{x} is an integer; optional otherwise. If \code{text} is a single string that is an existing file path, it is loaded automatically.}
  \item{dic}{A dictionary (data.frame), a list of dictionaries, or a character vector of file paths to dictionary files. If file paths are given, each is loaded with \code{\link{read_dictionary}}. If \code{NULL}, the built-in dictionary is loaded via \code{read_dictionary()}.}
  \item{mapping}{A data frame containing the sign mapping table with columns \code{syllables}, \code{name}, and \code{cuneiform}. If \code{NULL} (the default), the package's internal mapping file \file{etcsl_mapping.txt} is loaded.}
  \item{fill}{A pre-computed substring info data frame (as from \code{\link{init_substr_info}} or \code{\link{guess_substr_info}}). If \code{NULL}, it is computed automatically via \code{\link{guess_substr_info}}.}
  \item{min_freq}{Minimum frequency thresholds passed to \code{\link{ngram_frequencies}}. A numeric vector where the \emph{i}-th element is the minimum frequency for n-grams of length \emph{i}. Default is \code{c(6, 4, 2)}.}
  \item{sentence_prob}{Probability that a randomly chosen sign is part of a sentence with a verb in the data from which the dictionary was compiled, passed to \code{\link{prior_probs}}. Default is \code{1.0}.}
}
\details{
The gadget opens as a dialog window in RStudio (via \code{shiny::dialogViewer()}) and displays four sections on a single scrollable page. The first three sections (N-grams, Context, Grammar) can be collapsed individually. A sticky navigation menu at the top allows jumping to each section.

\describe{
  \item{N-gram Patterns}{Displays a merged table of n-gram combinations that appear in the current line: n-grams of length 2 or more from the full text (controlled by \code{min_freq}), combined with shared n-grams found in neighbouring lines. A \dQuote{Theme} column marks n-grams shared with the context. Frequencies refer to the full text.}
  \item{Context}{Shows neighbouring lines (up to 2 before and after) with frequent n-grams marked. Only available when \code{text} is provided and the line index is known.}
  \item{Grammar Probabilities}{Displays a bar chart of grammar probabilities for each sign in the line, computed via \code{\link{grammar_probs}} with the given \code{sentence_prob}.}
  \item{Translation}{The main interactive section with dictionary selection checkboxes, a bracket input field for editing the skeleton structure, an interactive skeleton display with type and translation fields, and a dictionary lookup panel. Clicking a dictionary row adopts its type and translation into the selected skeleton entry.}
}

When the line contains multiple sentences (separated by dots in the transliteration), skeleton entries belonging to different sentences are displayed with alternating background colours.

The bracket input field allows the user to add or modify brackets \code{()}, \code{<>}, \code{\{\}} to control the grouping structure of the skeleton. Pressing \dQuote{Update Skeleton} rebuilds the skeleton display while keeping all translations made so far in memory.
}
\value{
A \code{skeleton} object (character vector of class \code{c("skeleton", "character")}), generated by calling \code{\link{skeleton}} with the final bracket string and updated \code{fill} data frame. Returns \code{invisible(NULL)} if the user closes the window without clicking \dQuote{Done}.
}
\note{
The gadget opens as a dialog window in RStudio. Outside of RStudio, it falls back to the system browser.
}
\seealso{
\code{\link{skeleton}} for creating translation templates,
\code{\link{guess_substr_info}} for pre-computing substring translations,
\code{\link{look_up}} for interactive dictionary lookup,
\code{\link{ngram_frequencies}} for n-gram analysis,
\code{\link{grammar_probs}} for grammar probability computation,
\code{\link{prior_probs}} for prior probability computation,
\code{\link{mark_ngrams}} for marking n-grams in text
}
\examples{
\dontrun{

# Basic usage with a transliterated string
result <- translate("lugal kur-ra-ke4")

# Usage together with a complete text
x <- "<d-nu-dim2-mud> ki a. jal2 (e2-kur) ra. gaba jal2. an ki a"

dict_file <- system.file("extdata", "sumer-dictionary.txt", package = "sumer")
text_file <- system.file("extdata", "enki_and_the_world_order.txt", package = "sumer")

result <- translate(x,
                text = text_file,
                dic = dict_file,
                min_freq = c(6, 4, 2),
                sentence_prob = 0.25)
print(result)

# Try also with: x <- 9
}
}
\keyword{utilities}
