\name{read_dictionary}
\alias{read_dictionary}
\title{Read a Sumerian Dictionary from File}
\description{
Reads a Sumerian dictionary from a semicolon-separated text file, optionally
displaying the metadata header with author, version, and update information.
}
\usage{
read_dictionary(file = NULL, verbose = TRUE)
}
\arguments{
\item{file}{A character string specifying the path to the dictionary file.
If \code{NULL} (default), the package's built-in dictionary
\code{sumer-dictionary.txt} is loaded.}

\item{verbose}{Logical. If \code{TRUE} (default), the metadata header
(author, year, version, URL) is printed to the console.}
}
\value{
A data frame with the following columns:
\describe{
\item{sign_name}{The Sumerian sign name (e.g., \code{"A"}, \code{"AN"}, \code{"ME"})}
\item{row_type}{Type of entry: \code{"cunei."} (cuneiform character), \code{"reading"} (phonetic readings), or \code{"trans."} (translation)}
\item{count}{Number of occurrences for translations; \code{NA} for cuneiform and reading entries}
\item{type}{Grammatical type (e.g., \code{"S"}, \code{"V"}) for translations; empty string for other row types}
\item{meaning}{The cuneiform character(s), phonetic reading(s), or translated meaning depending on \code{row_type}}
}
}
\details{
\subsection{File Format}{
The function expects a semicolon-separated file with a metadata header.
Lines starting with \code{#} are treated as comments. The expected format is:

\preformatted{
###---------------------------------------------------------------
###                Sumerian Dictionary
###
### Author:  Robin Wellmann
### Year:    2026
### Version: 0.5
### Watch for Updates:
###   https://founder-hypothesis.com/en/sumerian-mythology/downloads/
###---------------------------------------------------------------
sign_name;row_type;count;type;meaning
A;cunei.;;;<here would be the cuneiform sign for A>
A;reading;;;{a, dur5, duru5}
A;trans.;3;S;water
}
}

\subsection{Encoding}{
The file is read with UTF-8 encoding to properly handle cuneiform characters.
}
}
\seealso{
\code{\link{save_dictionary}} for saving dictionaries to file,
\code{\link{make_dictionary}} and \code{\link{convert_to_dictionary}} for
creating dictionaries.
}
\examples{
# Load the built-in dictionary
dic <- read_dictionary()

# Load a custom dictionary
filename <- system.file("extdata", "sumer-dictionary.txt", package = "sumer")
dic <- read_dictionary(filename)

# Look up an entry
look_up("d-suen", dic)

}
