% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subplot_K.R
\name{subplot_K}
\alias{subplot_K}
\title{Plot sub-environmental space K in E}
\usage{
subplot_K(
  subnic,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  col.axis = "azure3",
  lty.axis = 2,
  lwd.axis = 2,
  border.E = "black",
  col.E = "#92c5de",
  lty.E = 1,
  lwd.E = 1,
  border.K = "black",
  col.K = "#2c7fb8",
  lty.K = 1,
  lwd.K = 1,
  col.Gk.pos = "red",
  col.Gk.pt = "black",
  cex.Gk.pos = 1,
  pch.Gk.pos = 21,
  col.Gk.lab = "black",
  cex.Gk.lab = 0.8,
  fac.Gk.lab = 1.5,
  col.su = "#b35806",
  pt.su = "black",
  cex.su = 0.7,
  pch.su = 1,
  leg = TRUE,
  posi.leg = "topleft",
  bty.leg = "n",
  ...
)
}
\arguments{
\item{subnic}{an object of class \code{subniche}.}

\item{main}{a main title for the plot, see \link[graphics]{title} for more details.}

\item{xlab}{label for x-axis, see \link[graphics]{title} for more details.}

\item{ylab}{label for y-axis, see \link[graphics]{title} for more details.}

\item{col.axis}{axis color, see \link[graphics]{par} for more details.}

\item{lty.axis}{axis line type, see \link[graphics]{par} for more details.}

\item{lwd.axis}{axis width, see \link[graphics]{par} for more details.}

\item{border.E}{color border of E polygon, see \link[graphics]{polygon} for more details.}

\item{col.E}{inside color of E polygon, see \link[graphics]{polygon} for more details.}

\item{lty.E}{line type for the E border, see \link[graphics]{polygon} for more details.}

\item{lwd.E}{line width for the E border, see \link[graphics]{polygon} for more details.}

\item{border.K}{color border of K polygon, see \link[graphics]{polygon} for more details.}

\item{col.K}{inside color of K polygon, see \link[graphics]{polygon} for more details.}

\item{lty.K}{line type for the K border, see \link[graphics]{polygon} for more details.}

\item{lwd.K}{line width for the K border, see \link[graphics]{polygon} for more details.}

\item{col.Gk.pos}{color of the point representing Gk, see \link[graphics]{points} for more details.}

\item{col.Gk.pt}{point color contour if pch=21:25.}

\item{cex.Gk.pos}{size of the point representing Gk, see \link[graphics]{points} for more details.}

\item{pch.Gk.pos}{type of the point representing Gk, see \link[graphics]{points} for more details.}

\item{col.Gk.lab}{color of the Gk labels, see see \link[graphics]{text} for more details.}

\item{cex.Gk.lab}{size of the Gk labels defaults NA for no labels, see see \link[graphics]{text} for more details.}

\item{fac.Gk.lab}{factor for moving the Gk labels from its original coordinates for clarity, by defaults they are multiply 1.2}

\item{col.su}{color of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{pt.su}{point color contour if pch=21:25.}

\item{cex.su}{size of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{pch.su}{type of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{leg}{a logical option for legend to be plotted or not, default leg=TRUE.}

\item{posi.leg}{legend location in the graph, see \link[graphics]{legend} for more details.}

\item{bty.leg}{the type of box to be drawn around the legends. The allowed values are "o" (the default) and "n". See \link[graphics]{legend} for more details}

\item{...}{further arguments passed to or from other methods.}
}
\description{
The function to represent the sub-environment K in E.
}
\examples{
library(subniche)
library(ade4)
data(doubs)
dudi1 <- dudi.pca(doubs$env, scale = TRUE, scan = FALSE, nf = 3)
nic1 <- niche(dudi1, doubs$fish, scann = FALSE)
# number of sites
N <- dim(nic1$ls)[1]
#Create a factor which defines the subsets
fact <- factor(c(rep(1,N/2),rep(2,N/2)))
# nic1 will be use as reference and fact will be use to define the subniches environment
subnic1 <- subniche(nic1, fact)
#Plot K in E
subplot_K(subnic1)

}
