% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twolines.R
\name{twolines}
\alias{twolines}
\title{Two-Lines Test of U-Shapes}
\usage{
twolines(
  f,
  graph = 1,
  link = "gaussian",
  data = NULL,
  pngfile = "",
  quiet = FALSE
)
}
\arguments{
\item{f}{A formula object specifying the model (e.g., y ~ x1 + x2 + x3).
The first predictor is the one tested for a u-shaped relationship.}

\item{graph}{Integer. If 1 (default), produces a plot. If 0, no plot is generated.}

\item{link}{Character string specifying the link function for the GAM model.
Default is "gaussian".}

\item{data}{An optional data frame containing the variables in the formula.
If not provided, variables are evaluated from the calling environment.}

\item{pngfile}{Optional character string. If provided, saves the plot to a PNG file
with the specified filename.}

\item{quiet}{Logical. If TRUE, suppresses the Robin Hood details messages.
Default is FALSE.}
}
\value{
A list containing:
\itemize{
  \item All elements from \code{reg2()}: \code{b1}, \code{b2}, \code{p1}, \code{p2},
    \code{z1}, \code{z2}, \code{u.sig}, \code{xc}, \code{glm1}, \code{glm2}, \code{rob1},
    \code{rob2}, \code{msg}, \code{yhat.smooth}
  \item \code{yobs}: Observed y values (adjusted for covariates if present)
  \item \code{y.hat}: Fitted values from GAM
  \item \code{y.ub}, \code{y.lb}: Upper and lower bounds for fitted values
  \item \code{y.most}: Most extreme fitted value
  \item \code{x.most}: x-value associated with most extreme fitted value
  \item \code{f}: Formula as character string
  \item \code{bx1}, \code{bx2}: Linear and quadratic coefficients from preliminary quadratic regression
  \item \code{minx}: Minimum x value
  \item \code{midflat}: Median of flat region
  \item \code{midz1}, \code{midz2}: Z-statistics at midpoint
}
}
\description{
Implements the two-lines test for U-shaped (or inverted U-shaped) relationships 
introduced by Simonsohn (2018).
}
\details{
Reference: 
Simonsohn, Uri (2018) "Two lines: A valid alternative to the invalid testing of 
U-shaped relationships with quadratic regressions." AMPPS, 538-555. 
\doi{10.1177/2515245918805755}


The test beings fitting a GAM model, predicting y with a smooth of x, and optionally with covariates. 
It identifies the interior most extreme value of fitted y, and adjusts from the matching x-value 
to set the breakpoint relying on the Robin Hood procedure introduced also by Simonsohn (2018).
It then estimates the (once) interrupted regression using that breakpoint,
and reports the slope and significance of the average slopes at either side of it. A U-shape 
is significant if the slopes are of opposite sign and are both individually significant.
}
\examples{
\donttest{
# Simple example with simulated data
set.seed(123)
x <- rnorm(100)
y <- -x^2 + rnorm(100)
data <- data.frame(x = x, y = y)
result <- twolines(y ~ x, data = data)

# With covariates
z <- rnorm(100)
y <- -x^2 + 0.5*z + rnorm(100)
data <- data.frame(x = x, y = y, z = z)
result <- twolines(y ~ x + z, data = data)

# Without data argument (variables evaluated from environment)
x <- rnorm(100)
y <- -x^2 + rnorm(100)
result <- twolines(y ~ x)
}

}
