% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-transformations.R
\name{qts2aavts}
\alias{qts2aavts}
\title{QTS Transformation to Angular Acceleration Vector Time Series}
\usage{
qts2aavts(x, spar = 0)
}
\arguments{
\item{x}{An object of class \link{qts}.}

\item{spar}{smoothing parameter, typically (but not necessarily) in
   \eqn{(0,1]}.  When \code{spar} is specified, the coefficient
   \eqn{\lambda} of the integral of the squared second derivative in the
   fit (penalized log likelihood) criterion is a monotone function of
   \code{spar}, see the details below.  Alternatively \code{lambda} may
   be specified instead of the \emph{scale free} \code{spar}=\eqn{s}.}
}
\value{
A time series stored as a \link[tibble:tibble]{tibble::tibble} with columns \code{time}, \code{x},
\code{y} and \code{z} containing the angular acceleration vector at each time point.
}
\description{
This function projects a quaternion time series into the space of angular
acceleration vectors.
}
\examples{
qts2aavts(vespa64$igp[[1]])
}
