% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_top_paths_fun.R
\name{plot_top_paths_fun}
\alias{plot_top_paths_fun}
\title{Plot the top risky call paths on a Sugiyama layout}
\usage{
plot_top_paths_fun(
  graph,
  all_paths_out,
  model.name = "",
  language = "",
  top_n = 10,
  alpha_non_top = 0.05
)
}
\arguments{
\item{graph}{A directed \code{tidygraph::tbl_graph} representing the call graph to
plot (typically the same graph used as input to \code{\link[=all_paths_fun]{all_paths_fun()}}).}

\item{all_paths_out}{Output from \code{\link[=all_paths_fun]{all_paths_fun()}}, i.e. a list
with elements \code{nodes} and \code{paths}. For backward compatibility, a \code{paths}
tibble can also be supplied directly; in that case node metrics are derived
from \code{graph} where possible.}

\item{model.name}{Character scalar used in the plot title (e.g., model name).}

\item{language}{Character scalar used in the plot title (e.g., language name).}

\item{top_n}{Integer. Number of highest-risk paths to display (default 10).}

\item{alpha_non_top}{Numeric in \deqn{[0, 1]}. Alpha (transparency) for edges that are
not on the top-risk paths. Smaller values fade background edges more.}
}
\value{
A \code{ggplot} object (invisibly). The plot is also printed as a side effect.
}
\description{
Visualizes the most risky entry-to-sink paths (by decreasing \code{path_risk_score})
computed by \code{\link[=all_paths_fun]{all_paths_fun()}}. Edges that occur on the top paths are
highlighted, with edge colour mapped to the mean path risk and edge width
mapped to the number of top paths using that edge. Nodes on the top paths
are emphasized, with node size mapped to in-degree and node fill mapped to
binned cyclomatic complexity.
}
\details{
The function selects the \code{top_n} paths by sorting \code{paths_tbl} on
\code{path_risk_score} (descending). For those paths, it:
\itemize{
\item builds an edge list from \code{path_nodes},
\item marks graph edges that appear on at least one top path,
\item computes \code{path_freq} (how many top paths include each edge),
\item computes \code{risk_mean_path} (mean of \code{risk_sum} across top paths that
include each edge),
\item highlights nodes that appear on any top path.
}

Node fills are based on \code{cyclomatic_complexity} using breaks
\verb{(-Inf, 10]}, \verb{(10, 20]}, \verb{(20, 50]}, \verb{(50, Inf]} as per Watson & McCabe (1996).

This function relies on external theming/label objects \code{theme_AP()} and
\code{lab_expr} being available in the calling environment or package namespace.
}
\examples{
data(synthetic_graph)
out <- all_paths_fun(graph = synthetic_graph, alpha = 0.6, beta = 0.3,
gamma = 0.1, complexity_col = "cyclo")
p <- plot_top_paths_fun(synthetic_graph, out, model.name = "MyModel", language = "R", top_n = 10)
p

}
\references{
Watson, A. H. and McCabe, T. J. (1996).
\emph{Structured Testing: A Testing Methodology Using the Cyclomatic Complexity
Metric}.
NIST Special Publication 500-235, National Institute of Standards and
Technology, Gaithersburg, MD.
doi:10.6028/NIST.SP.500-235
}
