% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{voltage}
\alias{voltage}
\title{Voltage response}
\format{
A data frame with 5 variables: \code{ID}, \code{Rep}, \code{DUnit}, \code{Voltage}, \code{Km}.
\describe{
  \item{ID}{Factor. Unique identifier for each observation.}
  \item{Rep}{Factor. Block number, corresponding to the experimental occasion (replicate).}
  \item{DUnit}{Factor. Measurement unit within each replicate (used in place of actual plot or plant randomization).}
  \item{Voltage}{Integer. Membrane voltage applied (in millivolts, mV; values range from -160 to 0).}
  \item{Km}{Numeric. Measured electric current for the respective voltage (unit appropriate to current, e.g., microamperes).}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
voltage
}
\description{
An experiment was carried out to assess the affinity of a sugar transporter protein in plant cells by measuring electric current (Km) in response to a range of substrate-associated voltages. Nine voltage levels, ranging from -160 to 0 mV, were tested (Voltage), and the experiment followed a randomized complete block design with two blocks corresponding to separate experimental occasions (Rep). For each combination, one observation was recorded per block (DUnit, reflecting individual measurement units within each replicate). This dataset enables analysis of how membrane voltage influences transporter activity, with blocking to account for any variation between experimental runs.
}
\examples{
lm(log(Km) ~ Rep + Voltage, data = voltage)

}
\keyword{datasets}
