% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_machine_learning.R
\name{sits_rfor}
\alias{sits_rfor}
\title{Train random forest models}
\usage{
sits_rfor(samples = NULL, num_trees = 100L, mtry = NULL, ...)
}
\arguments{
\item{samples}{Time series with the training samples
(tibble of class "sits").}

\item{num_trees}{Number of trees to grow. This should not be set to too
small a number, to ensure that every input
row gets predicted at least a few times (default: 100)
(integer, min = 20).}

\item{mtry}{Number of variables randomly sampled as candidates at
each split (default: NULL - use default value of
\code{randomForest::randomForest()} function, i.e.
\code{floor(sqrt(features))}).}

\item{...}{Other parameters to be passed
to `randomForest::randomForest` function.}
}
\value{
Model fitted to input data
                  (to be passed to \code{\link[sits]{sits_classify}}).
}
\description{
Use Random Forest algorithm to classify samples.
This function is a front-end to the \code{randomForest} package.
Please refer to the documentation in that package for more details.
}
\examples{
if (sits_run_examples()) {
    # Example of training a model for time series classification
    # Retrieve the samples for Mato Grosso
    # train a random forest model
    rf_model <- sits_train(samples_modis_ndvi,
        ml_method = sits_rfor
    )
    # classify the point
    point_ndvi <- sits_select(point_mt_6bands, bands = "NDVI")
    # classify the point
    point_class <- sits_classify(
        data = point_ndvi, ml_model = rf_model
    )
    plot(point_class)
}
}
\author{
Alexandre Ywata de Carvalho, \email{alexandre.ywata@ipea.gov.br}

Rolf Simoes, \email{rolfsimoes@gmail.com}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
