% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.probs_cube}
\alias{plot.probs_cube}
\title{Plot probability cubes}
\usage{
\method{plot}{probs_cube}(
  x,
  ...,
  tile = x[["tile"]][[1L]],
  roi = NULL,
  labels = NULL,
  palette = "YlGn",
  rev = FALSE,
  quantile = NULL,
  scale = 1,
  max_cog_size = 512L,
  legend_position = "outside",
  legend_title = "probs"
)
}
\arguments{
\item{x}{Object of class "probs_cube".}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tile to be plotted.}

\item{roi}{Spatial extent to plot in WGS 84 - named vector
(see notes below)}

\item{labels}{Labels to plot.}

\item{palette}{RColorBrewer or "cols4all" palette}

\item{rev}{Reverse order of colors in palette?}

\item{quantile}{Minimum quantile to plot}

\item{scale}{Scale to plot map (0.4 to 1.0)}

\item{max_cog_size}{Maximum size of COG overviews (lines or columns)}

\item{legend_position}{Where to place the legend (default = "outside")}

\item{legend_title}{Title of legend (default = "probs")}
}
\value{
A plot containing probabilities associated
                      to each class for each pixel.
}
\description{
plots a probability cube
}
\note{
To see which color palettes are supported, please run cols4all::c4a_gui().
To define a \code{roi} use one of:
     \itemize{
       \item{A path to a shapefile with polygons;}
       \item{A \code{sfc} or \code{sf} object from \code{sf} package;}
       \item{A \code{SpatExtent} object from \code{terra} package;}
       \item{A named \code{vector} (\code{"lon_min"},
            \code{"lat_min"}, \code{"lon_max"}, \code{"lat_max"}) in WGS84;}
       \item{A named \code{vector} (\code{"xmin"}, \code{"xmax"},
             \code{"ymin"}, \code{"ymax"}) with XY coordinates.}
      }

     Defining a region of interest using \code{SpatExtent} or XY values not
     in WGS84 requires the \code{crs} parameter to be specified.
     \code{sits_regularize()} function will crop the images
     that contain the region of interest().
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # plot the resulting probability cube
    plot(probs_cube)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
