% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intEffectAlphaTreat.R
\name{intEffectAlphaTreat}
\alias{intEffectAlphaTreat}
\title{Perform intervention on treatment process intensity}
\usage{
intEffectAlphaTreat(
  N = 10000,
  alpha = 0.5,
  tau = 5,
  years_lost = FALSE,
  plot = FALSE,
  nu = rep(1.1, 4),
  eta = rep(0.1, 4),
  beta_L_A = 1,
  beta_L_D = 1,
  beta_A_D = -0.5,
  beta_A_L = -1,
  beta_L0_A = 1,
  lower = 10^(-300),
  upper = 300
)
}
\arguments{
\item{N}{Integer. Number of individuals to simulate.}

\item{alpha}{Numeric. Multiplicative factor applied to the \eqn{\eta} parameter of the treatment process.}

\item{tau}{Numeric. Time point at which event proportions or years lost are compared.}

\item{years_lost}{Logical. If TRUE, compute years lost estimand instead of simple proportions.}

\item{plot}{Logical. If TRUE, output plots of the first 250 events.}

\item{nu}{Numeric vector of length 4. Scale parameters for Weibull hazards.}

\item{eta}{Numeric vector of length 4. Shape parameters for Weibull hazards.}

\item{beta_L_A}{Numeric. Effect of covariate L on treatment process A.}

\item{beta_L_D}{Numeric. Effect of covariate L on death process D.}

\item{beta_A_D}{Numeric. Effect of treatment process A on death process D.}

\item{beta_A_L}{Numeric. Effect of treatment process A on covariate L.}

\item{beta_L0_A}{Numeric. Effect of L0 on treatment process A.}

\item{lower}{Numeric. Lower bound for root-finding algorithm to invert cumulative hazard.}

\item{upper}{Numeric. Upper bound for root-finding algorithm.}
}
\value{
A list containing:
\describe{
\item{effect_A}{Proportion or years lost of treated patients under intervention.}
\item{effect_death}{Proportion or years lost of deaths under intervention.}
}
}
\description{
Calculate the effect of an intervention modifying the treatment process intensity.
}
\details{
This function simulates event history data from the Treatment scenario (see function simTreatment)
under intervention. We consider the intervention where
the \eqn{\eta} parameter of the treatment process is multiplied by a factor \code{alpha}.
It computes the proportion or years lost of death and treatment by time \eqn{\tau}
on intervened data.
}
\examples{
intEffectAlphaTreat()
}
