% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dk_order_glg.R
\name{dk_order_glg}
\alias{dk_order_glg}
\title{Density Probability Distribution of a K-th Order Statistic from a Generalized Log-gamma Distribution}
\usage{
dk_order_glg(x, mu = 0, sigma = 1, lambda = 1, k, n)
}
\arguments{
\item{x}{numeric, represents a real value.}

\item{mu}{numeric, represents the location parameter. Default value is 0.}

\item{sigma}{numeric, represents the scale parameter. Default value is 1.}

\item{lambda}{numeric, represents the shape parameter. Default value is 1.}

\item{k}{numeric, represents the K-th smallest value from a sample.}

\item{n}{numeric, represents the size of the sample of the generalized log-gamma distribution.}
}
\value{
A list of values of the density probability function of the k-th order statistic from a generalized log-gamma distribution.
}
\description{
\code{dk_order_glg} is used to obtain the density probability distribution of the k-th order statistic from a generalized log-gamma distribution.
}
\examples{
# The density probability distribution of 10-th order statistics at 0
# from a random sample of extreme value distribution with n=20.
dk_order_glg(0,0,1,1,k=10,n=20)
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Naradajah, S. and Rocha, R. (2016) Newdistns: An R Package for New Families of Distributions, Journal of Statistical Software.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
