% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_filter_helpers.R
\name{st_is_valid_filter_id}
\alias{st_is_valid_filter_id}
\title{Validate Custom Field Filter ID Format}
\usage{
st_is_valid_filter_id(filter_id)
}
\arguments{
\item{filter_id}{Character string. The filter ID to validate}
}
\value{
Logical. TRUE if valid format, FALSE otherwise
}
\description{
Checks if a filter ID matches the expected 24-character hexadecimal format
used by Sensor Tower.
}
\examples{
\dontrun{
# Valid filter ID
st_is_valid_filter_id("687df26ac5a19ebcfe817d7f")  # TRUE

# Invalid filter IDs
st_is_valid_filter_id("invalid")  # FALSE
st_is_valid_filter_id("687df26ac5a19ebcfe817d7")  # FALSE (too short)
}
}
