% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_game_summary.R
\name{st_game_summary}
\alias{st_game_summary}
\title{Fetch Game Market Summary Data}
\usage{
st_game_summary(
  categories = 7001,
  countries,
  os,
  date_granularity,
  start_date,
  end_date,
  auth_token = NULL,
  base_url = "https://api.sensortower.com",
  enrich_response = TRUE
)
}
\arguments{
\item{categories}{Character string or numeric vector. Game category IDs to 
analyze. Defaults to 7001 (a popular game category). Use `st_categories()` 
to find valid category IDs.}

\item{countries}{Character vector or comma-separated string. Country codes 
(e.g., `"US"`, `c("US", "GB")`, `"WW"` for worldwide) to analyze. Required.}

\item{os}{Character string. Operating System. Must be one of "ios", "android", 
or "unified". Required.}

\item{date_granularity}{Character string. Time granularity for aggregation. 
Must be one of "daily", "weekly", "monthly", or "quarterly". Required.}

\item{start_date}{Character string or Date object. Start date for the query 
in "YYYY-MM-DD" format. Required.}

\item{end_date}{Character string or Date object. End date for the query 
in "YYYY-MM-DD" format, inclusive. Required.}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}

\item{base_url}{Optional. Character string. The base URL for the API.}

\item{enrich_response}{Optional. Logical. If `TRUE` (default), enriches
the response with readable column names and processes the data.}
}
\value{
A [tibble][tibble::tibble] with game market summary data including:
  - **Category information**: Game category details
  - **Geographic data**: Country-level breakdowns
  - **Downloads**: Unified iOS (iPhone + iPad combined) and Android download estimates
  - **Revenue**: Unified iOS (iPhone + iPad combined) and Android revenue estimates
  - **Time series**: Data broken down by specified granularity
  
  **Automatic Data Combination**: For iOS and unified platforms, iPhone and iPad
  data are automatically combined into single "iOS Downloads" and "iOS Revenue" 
  columns for simplified analysis.
}
\description{
Retrieves aggregated download and revenue estimates by game categories, 
countries, and date ranges. This provides a market overview of game 
performance across different segments.
}
\section{API Endpoint Used}{

  - **Game Summary**: `GET /v1/\{os\}/games_breakdown`
}

\section{Field Mappings and Processing}{

  The API returns abbreviated field names which are automatically mapped to 
  descriptive names and processed:
  - **iOS**: `iu` + `au` = iOS Downloads (combined), `ir` + `ar` = iOS Revenue (combined)
  - **Android**: `u` = Android Downloads, `r` = Android Revenue
  - **Common**: `cc` = Country Code, `d` = Date, `aid` = App ID
  
  iPhone and iPad data are automatically combined for simplified analysis.
}

\examples{
\dontrun{
# Basic game market summary (last 30 days, worldwide)
game_summary <- st_game_summary()

# Specific categories and countries
rpg_summary <- st_game_summary(
  categories = c(7001, 7002),
  countries = c("US", "GB", "DE"),
  date_granularity = "weekly"
)

# Monthly summary for iOS games in the US
ios_monthly <- st_game_summary(
  os = "ios",
  countries = "US", 
  date_granularity = "monthly",
  start_date = "2024-01-01",
  end_date = "2024-06-30"
)
}

}
\seealso{
[st_categories()], [st_top_charts()], [st_metrics()]
}
