% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{cborenc}
\alias{cborenc}
\title{CBOR Encode}
\usage{
cborenc(x)
}
\arguments{
\item{x}{R object to encode. Supported types: NULL, logical, integer, double,
character, raw vectors, and lists (named lists become CBOR maps, unnamed
become CBOR arrays).}
}
\value{
A raw vector containing the CBOR-encoded data.
}
\description{
Encode an R object to CBOR (Concise Binary Object Representation, RFC 8949)
format.
}
\details{
This implementation supports a minimal CBOR subset:
\itemize{
\item Unsigned and negative integers
\item Float64
\item Byte strings (raw vectors)
\item Text strings (UTF-8)
\item Simple values: false, true, null, undefined
\item Arrays (unnamed lists/vectors)
\item Maps (named lists)
}

Scalars (length-1 vectors) encode as CBOR primitives; longer vectors encode
as CBOR arrays. NA values encode as CBOR undefined. Names on atomic vectors
are ignored.

Note: atomic vectors do not round-trip perfectly as CBOR arrays decode to
lists. Named lists round-trip correctly as CBOR maps.
}
\examples{
# Encode a named list (becomes CBOR map)
cborenc(list(a = 1L, b = "hello"))

# Round-trip
cbordec(cborenc(list(x = TRUE, y = as.raw(1:3))))

}
\seealso{
\code{\link[=cbordec]{cbordec()}}
}
