################################################################################
# -------------------------------- DCT.matrix -------------------------------- #
################################################################################

test_that("DCT.matrix output type is correct", {
  expect_true(is.matrix(DCT.matrix(10)))                                        # the output is a matrix
  expect_true(
    sum(DCT.matrix(10)%*%DCT.matrix(10) - diag(10))< .Machine$double.eps        # the output is orthogonal
  )
})

################################################################################
# ----------------------------- acf2sdf & sdf2acf ---------------------------- #
################################################################################

test_that("acf2sdf is inverse operation of sdf2acf", {
  x <- rnorm(20)
  expect_equal(sdf2acf(acf2sdf(x)), x)
  expect_equal(acf2sdf(sdf2acf(x)), x)
})

################################################################################
# -------------------------------- Q_pminus1 --------------------------------- #
################################################################################

test_that("Q_pminus1 rejects invalid input", {
  n <- 30
  x <- seq(1, n)/n
  expect_error(Q_pminus1(-1, x))
})

test_that("Q_pminus1 of order 0 is constant 1", {
  n <- 100
  x <- seq(1, n)/n
  expect_equal(Q_pminus1(0, x), rep(1, n))
})