################################################################################
# --------------------------- data_transformation ---------------------------- #
################################################################################

test_that("data_transformation output type and length are correct", {
  p <- 10
  x <- rnorm(p)
  D <- diag(p)
  Te <- 4
  m <- 2
  result <- data_transformation(x, D, Te, m)
  
  expect_type(result, "double")
  expect_true(is.numeric(result))
  expect_length(result, 2*Te-2)
})

################################################################################
# ------------------------------ data_binning -------------------------------- #
################################################################################

test_that("data_binning rejects invalid input", {
  p <- 200
  Te <- 201
  w <- rep(1, p)
  
  expect_error(data_binning(w = w, Te = Te),"Te must be smaller")
})


test_that("data_binning output type and length are correct", {
  p <- 200
  Te <- 4
  w <- rep(1, p)
  result <- data_binning(w = w, Te = Te)
  
  expect_type(result, "double")
  expect_true(is.numeric(result))
  expect_length(result, Te)
})

################################################################################
# ----------------------------------- VST ------------------------------------ #
################################################################################
test_that("VST output is correct", {
  w_star <- 1:15
  m <- 10
  result <- VST(w_star = w_star, m = m)
  expected <- log(w_star / m) / sqrt(2)
  
  expect_equal(result, expected)
})