% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplot.R
\name{multiplot}
\alias{multiplot}
\title{Combine multiple ggplot objects into a single layout}
\usage{
multiplot(..., cols = 1)
}
\arguments{
\item{...}{One or more \code{ggplot2} objects.}

\item{cols}{Integer specifying the number of columns in the layout.}
}
\value{
A grid object displaying multiple plots arranged in the specified layout.
}
\description{
The \code{multiplot} function arranges multiple \code{ggplot2} objects
into a single plotting layout with a specified number of columns.
}
\details{
Multiple \code{ggplot2} objects can be provided either as separate
arguments via \code{...}.
The function uses the \code{grid} package to control the layout.
}
\examples{

# Example using output from TTEST_DDCt
data1 <- read.csv(system.file("extdata", "data_ttest18genes.csv", package = "rtpcr"))
out <- TTEST_DDCt(
  data1,
  paired = FALSE,
  var.equal = TRUE,
  numberOfrefGenes = 1)
  
p1 <- plotFactor(out, 
  x_col = "gene",
  y_col = "log2FC", 
  Lower.se_col = "Lower.se.log2FC",
  Upper.se_col = "Upper.se.log2FC", 
  letters_col = "sig")
  
p2 <- plotFactor(out, 
  x_col = "gene",
  y_col = "RE", 
  Lower.se_col = "Lower.se.RE",
  Upper.se_col = "Upper.se.RE", 
  letters_col = "sig")
  
  

# Example using output from ANOVA_DCt
data2 <- read.csv(system.file("extdata", "data_1factor.csv", package = "rtpcr"))
out2 <- ANOVA_DCt(
  data2,
  numOfFactors = 1,
  numberOfrefGenes = 1,
  block = NULL)
  
df <- out2$relativeExpression

p3 <- plotFactor(
  df,
  x_col = "SA",
  y_col = "RE",
  Lower.se_col = "Lower.se.RE",
  Upper.se_col = "Upper.se.RE",
  letters_col = "sig",
  letters_d = 0.1,
  col_width = 0.7,
  err_width = 0.15,
  fill_colors = "skyblue",
  alpha = 1,
  base_size = 14)

# Combine plots into a single layout
multiplot(p1, p2, cols = 2)

multiplot(p1, p3, cols = 2)
}
\author{
Pedro J. (adapted from \url{https://gist.github.com/pedroj/ffe89c67282f82c1813d})
}
