% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_statuses.R
\name{stream_timeline}
\alias{stream_timeline}
\alias{stream_timeline_public}
\alias{stream_timeline_hashtag}
\alias{stream_timeline_list}
\title{Collect live streams of Mastodon data}
\usage{
stream_timeline_public(
  timeout = 30,
  local = FALSE,
  file_name = NULL,
  append = TRUE,
  instance = NULL,
  token = NULL,
  anonymous = FALSE,
  verbose = TRUE
)

stream_timeline_hashtag(
  hashtag = "rstats",
  timeout = 30,
  local = FALSE,
  file_name = NULL,
  append = TRUE,
  instance = NULL,
  token = NULL,
  anonymous = FALSE,
  verbose = TRUE
)

stream_timeline_list(
  list_id,
  timeout = 30,
  file_name = NULL,
  append = TRUE,
  instance = NULL,
  token = NULL,
  anonymous = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{timeout}{Integer, Number of seconds to stream toots for. Stream indefinitely with timeout = Inf. The stream can be interrupted at any time, and file_name will still be a valid file.}

\item{local}{logical, Show only local statuses (either statuses from your instance or the one provided in \code{instance})?}

\item{file_name}{character, name of file. If not specified, will write to a temporary file stream_toots*.json.}

\item{append}{logical, if TRUE will append to the end of file_name; if FALSE, will overwrite.}

\item{instance}{character, the server name of the instance where the status is located. If \code{NULL}, the same instance used to obtain the token is used.}

\item{token}{user bearer token (read from file by default)}

\item{anonymous}{logical, should the API call be made anonymously? Defaults to TRUE but some instances might need authentication here}

\item{verbose}{logical whether to display messages}

\item{hashtag}{character, hashtag to stream}

\item{list_id}{character, id of list to stream}
}
\value{
does not return anything. Statuses are written to file
}
\description{
Collect live streams of Mastodon data
}
\details{
\describe{
\item{stream_timeline_public}{stream all public statuses on any instance}
\item{stream_timeline_hashtag}{stream all statuses containing a specific hashtag}
\item{stream_timeline_list}{stream the statuses of a list}
}
}
\examples{
\dontrun{
# stream public timeline for 30 seconds
stream_timeline_public(timeout = 30, file_name = "public.json")
# stream timeline of mastodon.social  for 30 seconds
stream_timeline_public(
    timeout = 30, local = TRUE,
    instance = "mastodon.social", file_name = "social.json"
)

# stream hashtag timeline for 30 seconds
stream_timeline_hashtag("rstats", timeout = 30, file_name = "rstats_public.json")
# stream hashtag timeline of mastodon.social  for 30 seconds
stream_timeline_hashtag("rstats",
    timeout = 30, local = TRUE,
    instance = "fosstodon.org", file_name = "rstats_foss.json"
)
# json files can be parsed with parse_stream()
parse_stream("rstats_foss.json")
}
}
