% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tasks.R
\name{update_task}
\alias{update_task}
\title{Update a task}
\usage{
update_task(
  task_id,
  content = NULL,
  description = NULL,
  priority = NULL,
  due_string = NULL,
  due_date = NULL,
  labels = NULL,
  verbose = TRUE,
  token = get_todoist_api_token()
)
}
\arguments{
\item{task_id}{id of the task to update}

\item{content}{new content/title for the task}

\item{description}{new description for the task}

\item{priority}{priority (1-4, 4 being highest)}

\item{due_string}{due date as string (e.g., "tomorrow", "every monday")}

\item{due_date}{due date as date (format: YYYY-MM-DD)}

\item{labels}{vector of label names}

\item{verbose}{boolean that make the function verbose}

\item{token}{todoist API token}
}
\value{
id of the updated task (invisible)
}
\description{
Update a task
}
\examples{
\dontrun{
update_task("12345", content = "Updated task name")
}
}
