% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffMRM.R
\name{getMRMAreas}
\alias{getMRMAreas}
\title{Extract the peak areas for MRM mass transitions for a given well}
\usage{
getMRMAreas(scanfile, tic, sample, ejections, well, removeBaseline = TRUE)
}
\arguments{
\item{scanfile}{A file path to a Sciex raw scan file (extension .wiff.scan)
containing the raw data referenced by the .wiff file from which the other
parameters were extracted}

\item{tic}{A total ion chromatogram data.frame as extracted by \code{\link[=getTIC]{getTIC()}} or
\code{\link[=getAllTIC]{getAllTIC()}}}

\item{sample}{A "sample" object representing a run in a .wiff file, from the
\code{samples} field of an \code{rtmsWiffReader} object, containing information about
the mass transitions measured in that run}

\item{ejections}{An ejection table listing the timing and boundaries of the
total ion chromatogram peaks for all shots in the run, as returned by
\code{\link[=measureEjections]{measureEjections()}}}

\item{well}{The well (a string) or well index (an integer) to be measured}

\item{removeBaseline}{If TRUE, baseline intensity for each mass transition
will be subtracted from the intensities in each ejection, to account for
baseline intensities measured near the lower limit of quantitation}
}
\value{
A data frame containing the total intensity for each mass transition
and each ejection; see Details for column specifics.
}
\description{
Extract the peak areas for MRM mass transitions for a given well
}
\details{
The table return includes a measurement of total area for each of the mass
transitions listed in \code{sample}.  It contains one row for each measured shot
each mass transition, with the following columns:
\itemize{
\item \code{shotorder}: The order of the peak within the shots fired during the run
\item \code{well}: The alphanumeric well name of the well from which the shot was
fired
\item \code{time}: The time (in seconds) after the beginning of the run at which the
intensity from the shot was at its peak
\item \code{massindex}: The index of the measured mass transition in the set of masses
in the given sample
\item \code{mass}: The name of the mass transition measured (often a compound name or
id)
\item \code{area}: The intensity area (in counts) for that particular mass transition
from that shot's peak
}
}
