% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rosario.R
\name{rosario}
\alias{rosario}
\title{Generate cyclic and mirrored permutations of a time series}
\usage{
rosario(numvec)
}
\arguments{
\item{numvec}{Numeric vector representing a single biological identity'
distributions across ordered time intervals. Time intervals are assumed to be
circular (e.g., hours of the day, months of the year), so the last interval
is treated as adjacent to the first. Biological identities can be
individuals, populations, species or communities.}
}
\value{
A list of numeric vectors with all the permutations in the time series,
including the mirror patterns.
}
\description{
For a numeric vector, creates the set of cyclic shifts and their
mirror images (reverse order), preserving shape but changing location along
the cycle. The suite of vectors and mirrors represent a complete set
of possible distributions.
}
\examples{
rosario(c(40, 25, 18, 10, 5, 2))
}
\seealso{
\code{\link[=vec_permutation]{vec_permutation()}}, \code{\link[=rosario_sample]{rosario_sample()}}
}
