% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_classes.R
\name{get_tomic_table}
\alias{get_tomic_table}
\title{Get Tomic Table}
\usage{
get_tomic_table(tomic, table_type)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{table_type}{The type of table to extract from the \code{tomic} object.
\describe{
  \item{tidy}{one row per measurements with feature and sample attributes added. Equivalent to the $data field of a tidy omic object}
  \item{measurements}{one row per measurements defined a feature and sample foreign key. Equivalent to the $measurements field of a triple omic object}
  \item{features}{one row per feature defined by a feature primary key. Equivalent to the $features field of a triple omic object}
  \item{samples}{one row per sample defined by a sample primary key. Equivalent to the $samples field of a triple omic object}
}}
}
\value{
a tibble matching the \code{table_type} of the \code{tomic} object
}
\description{
Extract one of the specific tables from a tomic object
}
\examples{
get_tomic_table(brauer_2008_triple, "samples")
get_tomic_table(brauer_2008_tidy, "features")
}
