% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rofanova}
\alias{rofanova}
\title{Robust Functional Analysis of Variance}
\usage{
rofanova(
  X,
  label_1,
  label_2 = NULL,
  B = 100,
  cores = 1,
  family = "bisquare",
  eff = 0.95,
  mu0_g = NULL,
  scale = NULL,
  maxit = 50,
  tol = 1e-04
)
}
\arguments{
\item{X}{Either an object of class  \code{fdata} for monodimensional functional data  or an object of class \code{fdata2d} for bi-dimensional functional data.}

\item{label_1}{A vector of containing group label corresponding to the first main effect.}

\item{label_2}{A vector of containing group label corresponding to the second main effect. If it is NULL, the one-way RoFANOVA is performed.
Otherwise, the two-way RoFANOVA with interaction is employed. Default is NULL.}

\item{B}{The number of permutations used to approximate the p-value in the permutation test. Default is 1000.}

\item{cores}{If \code{cores}>1, then parallel computing is used, with \code{cores} cores. Default is 1.}

\item{family}{The family of loss function for the calculation of the equivariant functional M-estimator. The values allowed are
"bisquare" for the bisquare or Tukey's biweight family of loss functions;  "huber" for the the Huber's family of loss functions;
"optimal" for the  optimal family of loss functions; "hampel" for the the Hampel's family of loss functions; "median" for the median loss function.
A non-robust functional estimator of the mean based on the standard least squares loss function is used with the value "mean". Default is "bisquare".}

\item{eff}{Asymptotic efficiency of the equivariant functional M-estimator. When \code{family} is either "mean" or "median", \code{eff} is ignored.}

\item{mu0_g}{Initial estimate  used in re-weighted least-squares algorithm to compute the equivariant functional M-estimator.
If NULL the standard non-robust functional mean is used. Default is NULL.}

\item{scale}{Estimate of the standard error of \code{X}. If NULL, the functional normalized median absolute deviation estimator is used. Default is NULL.}

\item{maxit}{The maximum number of iterations allowed in the re-weighted least-squares algorithm to compute the equivariant functional M-estimator.}

\item{tol}{The tolerance for the stopping condition of the re-weighted least-squares algorithm to compute the equivariant functional M-estimator.
The algorithm stops when the relative variation of the weighted norm sum between two consecutive iterations is less than \code{tol}.}
}
\value{
\code{pval_vec} Vector of p-value of corresponding to the test of significance of the whole model, the main effects and the interaction.  For one-way RoFANOVA, it is the p-value corresponding to the test of the main effect.

\code{Tr_obs} The observed value of the test statistic.

\code{Tr_perm} The values of the test statistic for each permutation.

\code{mod} A list containing the following arguments:
\itemize{
\item \code{Tr}: The observed value of the test statistic.

\item\code{global_mean}: The robust estimate of functional grand mean.

\item\code{group_mean_1}: The robust estimate of the first functional main effect.

\item\code{group_mean_2}: The robust estimate of the second functional main effect. For one-way RoFANOVA, it is NULL.

\item\code{group_mean_ij}: The robust estimate of the group functional mean. For one-way, it RoFANOVA is NULL.

\item\code{scale}: The robust estimate of functional standard deviation.

\item\code{scale_1}: The robust estimate of functional standard deviation corresponding to the first functional main effect.

\item\code{scale_2}: The robust estimate of functional standard deviation corresponding to the second functional main effect. For one-way RoFANOVA, it is NULL.

\item\code{scale_re}: The robust estimate of the  functional standard deviation of the error distribution. For one-way RoFANOVA, it is NULL.

\item\code{X}: The variable \code{X}.

\item\code{label_1}: The vector of containing group label corresponding to the first main effect.

\item\code{label_2}: The vector of containing group label corresponding to the second main effect. For one-way RoFANOVA, it is NULL.

\item\code{family}: The family of loss function for the calculation of the equivariant functional M-estimator.
}
}
\description{
Robust Functional Analysis of Variance (RoFANOVA) allows identifying the presence of significant differences, in terms of
functional mean, among groups of a functional data by being robust against the presence of outliers  (Centofanti et al., 2023).
}
\examples{
library(rofanova)
data_out<-simulate_data(scenario="one-way")
label_1=data_out$label_1
X_fdata<-data_out$X_fdata
B=10
cores=1
per_list_median<-rofanova(X_fdata,label_1,B = B,family="median",cores=cores)
pvalue_median_vec<-per_list_median$pval_vec
per_list_huber<-rofanova(X_fdata,label_1,B = B,family="huber",cores=cores)
pvalue_huber_vec<-per_list_huber$pval_vec
per_list_bisquare<-rofanova(X_fdata,label_1,B = B,family="bisquare",cores=cores)
pvalue_bisquare_vec<-per_list_bisquare$pval_vec
per_list_hampel<-rofanova(X_fdata,label_1,B = B,family="hampel",cores=cores)
pvalue_hampel_vec<-per_list_hampel$pval_vec
per_list_optimal<-rofanova(X_fdata,label_1,B = B,family="optimal",cores=cores)
pvalue_optimal<-per_list_optimal$pval
}
\references{
Centofanti, F., Colosimo, B. M., Grasso, M. L., Menafoglio, A., Palumbo, B., & Vantini, S. (2023).
Robust functional ANOVA with application to additive manufacturing.
\emph{Journal of the Royal Statistical Society Series C: Applied Statistics}, 72(5), 1210-1234.
}
\seealso{
\code{\link{fusem}} \code{\link{funmad}}
}
