% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_humanremains.R
\name{road_get_human_remains}
\alias{road_get_human_remains}
\title{Get human remains from the ROAD database}
\usage{
road_get_human_remains(
  continent = NULL,
  subcontinent = NULL,
  country = NULL,
  locality_type = NULL,
  cultural_period = NULL,
  technocomplex = NULL,
  category = NULL,
  age_min = NULL,
  age_max = NULL,
  assemblages = NULL,
  human_genus = NULL,
  human_species = NULL
)
}
\arguments{
\item{continent}{specifies the continent(s) (e.g. Africa, Europe, Asia).
Run \code{road_list_argument_values("continent")} to display possible values.
The argument \code{continent} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{subcontinent}{specifies the continental region(s) (e.g. Southern Europe).
Run \code{road_list_argument_values("subcontinent")} to display possible values.
The argument \code{subcontinent} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{country}{specifies the name of the country where a locality is situated
(e.g. Germany, Kenya, Saudi Arabia). Run \code{road_list_argument_values("country")}
to display possible values.
The argument \code{country} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{locality_type}{specifies the type of locality (e.g. cave, rockshelter, open air).
Run \code{road_list_argument_values("locality_type")} to display possible values.
The argument \code{locality_type} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{cultural_period}{specifies the main cultural epoch(s) and includes the
Eurasian Paleolithic (Lower, Middle, Upper, Epi-) and the African Stone Age
(Earlier, Middle, Later). Run \code{road_list_argument_values("cultural_period")}
to display possible values. The argument \code{cultural_period} is a string
(one item) or vector of strings (one or more items); defaults to NULL.}

\item{technocomplex}{specifies an archaeological culture or named stone tool
industry (e.g. Oldowan, Acheulean, Mousterian).
Run \code{road_list_argument_values("technocomplex")} to display possible values.
The argument \code{technocomplex} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{category}{specifies the assemblage category with the classes
human remains, raw material, typology, technology, function, organic tools,
symbolic artifacts, feature, miscellaneous finds, paleofauna, animal remains,
plant remains. The argument \code{category} is a string (one item) or
vector of strings (one or more items); defaults to NULL.}

\item{age_min}{specifies the minimum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_min} will be converted to an integer; defaults to NULL.}

\item{age_max}{specifies the maximum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_max} will be converted to an integer; defaults to NULL.}

\item{assemblages}{specifies a data frame necessarily containing columns 
locality_id, assemblage_id. It can be  generated as return value of the 
function 'road_get_assemblages'. It can be used instead of the locality 
and assemblage search parameters to filter the results.}

\item{human_genus}{specifies the genus to which the described fossil is
attributed to. Possible entries include: "Australopithecus", "Homo", "indet",
etc. Run \code{road_list_argument_values("human_genus")} to display possible
values. The argument \code{human_genus} is a string (one item) or vector of
strings; defaults to NULL.}

\item{human_species}{specifies the species to which the described fossil is
attributed. Possible entries include: "afarensis", "sapiens", "erectus" or
"sp." for unidentified species.
Run \code{road_list_argument_values("human_species")} to display
possible values.The parameter \code{human_species} is a string (one item) or
vector of strings; defaults to NULL.}
}
\value{
A data frame with human remains information. Rows represent individual
human remains finds, columns contain standard outputs and human remains-related details on:

\code{human_remains_id}: Unique identifier for each human remains entry per assemblage.

\code{genus}: The genus to which the described fossil is attributed to.

\code{species}: The species to which the described fossil is attributed to.

\code{age}: The age class of the individual at death (e.g. infant, juvenile, adult, subadult, mature).

\code{sex}: The sex of the individual (e.g. F for female or M for male).

\code{skeletal_element}: The attribute skeletal_element is an anatomical designation and contains a brief description of
the fossil described in the dataset. Cranial and postcranial bones are named by their anatomical
appellation in Latin, for example: humerus, (os) capitatum, (os) zygomaticum, os coxae, etc. Left
and right are denoted as "L" and "R". Teeth are abbreviated by letters (M = molars, P = premolars,
I = incisors, C = canines) combined with Arabic numerals ([automatically generated]) to definitively
assign their position in the dental arch. The appellations "upper" and "lower" are not expressed
through a subscript or superscript number but written as words. Possible examples include: upper
L M1, R humeral epiphysis, natural endocast, etc.

\code{human_remains_category}: The attribute category indicates the element group to which the fossil belongs.
C for cranial bones, D for dental remains, P for postcranial bones, E for natural endocasts,
I for imprints that are negative molds of body parts, including footprints, S for sediment (containing human aDNA).
}
\description{
The \strong{\code{road_get_human_remains}} function retrieves data on human
remains from the ROAD database. Human remains are human fossil finds and always
associated with an assemblage. A human remain is a direct and substantial
piece of evidence for the presence of fossil hominids at a particular locality.
Next to the assemblage information the function returns genus, species,
age and sex if available and further information regarding the remains.
The dataset may also include indirect evidence such as fossil endocasts and
footprints.
}
\details{
Use the parameters to filter the results or omit them to retrieve a broader
dataset. Genus and species parameters can be entered as a vector of strings
to search for multiple entries. If genus and species are both specified,
most of the time it's more sensible to enter them as single strings and not
as vectors with multiple search words to recieve useful results.
}
\examples{
\donttest{road_get_human_remains(subcontinent = "East Africa", human_genus = c('Paranthropus'))}
\donttest{road_get_human_remains(subcontinent = 'Caucasus', human_genus = 'Homo', 
                       human_species = 'neanderthalensis')}
}
