% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-binding.R
\name{env_get}
\alias{env_get}
\alias{env_get_list}
\title{Get an object in an environment}
\usage{
env_get(env = caller_env(), nm, default, inherit = FALSE, last = empty_env())

env_get_list(
  env = caller_env(),
  nms,
  default,
  inherit = FALSE,
  last = empty_env()
)
}
\arguments{
\item{env}{An environment.}

\item{nm}{Name of binding, a string.}

\item{default}{A default value in case there is no binding for \code{nm}
in \code{env}.}

\item{inherit}{Whether to look for bindings in the parent
environments.}

\item{last}{Last environment inspected when \code{inherit} is \code{TRUE}.
Can be useful in conjunction with \code{\link[base:ns-topenv]{base::topenv()}}.}

\item{nms}{Names of bindings, a character vector.}
}
\value{
An object if it exists. Otherwise, throws an error.
}
\description{
\code{env_get()} extracts an object from an enviroment \code{env}. By
default, it does not look in the parent environments.
\code{env_get_list()} extracts multiple objects from an environment into
a named list.
}
\examples{
parent <- child_env(NULL, foo = "foo")
env <- child_env(parent, bar = "bar")

# This throws an error because `foo` is not directly defined in env:
# env_get(env, "foo")

# However `foo` can be fetched in the parent environment:
env_get(env, "foo", inherit = TRUE)

# You can also avoid an error by supplying a default value:
env_get(env, "foo", default = "FOO")
}
\seealso{
\code{\link[=env_cache]{env_cache()}} for a variant of \code{env_get()} designed to
cache a value in an environment.
}
