/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.regarima;

import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.x13.base.api.regarima.RegressionTestSpec;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class EasterSpec
implements Validatable<EasterSpec> {
    public static final EasterSpec DEFAULT_UNUSED = (EasterSpec)EasterSpec.builder().build();
    public static final int DEF_EASTERDUR = 8;
    private final int duration;
    private final RegressionTestSpec test;
    private final Type type;
    private final Parameter coefficient;

    public boolean isAutomatic() {
        return this.type != Type.Unused && this.test == RegressionTestSpec.Add;
    }

    public static Builder builder() {
        return new Builder().type(Type.Unused).duration(8).test(RegressionTestSpec.None);
    }

    public EasterSpec validate() throws IllegalArgumentException {
        if (this.duration <= 0 || this.duration > 20) {
            throw new IllegalArgumentException("Should be in [1,20]");
        }
        if (this.test != RegressionTestSpec.None && Parameter.isFixed((Parameter)this.coefficient)) {
            throw new IllegalArgumentException("Fixed coefficient should not be used with testing");
        }
        return this;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_UNUSED);
    }

    public boolean isUsed() {
        return this.type != Type.Unused;
    }

    public static EasterSpec none() {
        return DEFAULT_UNUSED;
    }

    public boolean hasFixedCoefficient() {
        return this.coefficient != null && this.coefficient.isFixed();
    }

    @Generated
    EasterSpec(int duration, RegressionTestSpec test, Type type, Parameter coefficient) {
        this.duration = duration;
        this.test = test;
        this.type = type;
        this.coefficient = coefficient;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().duration(this.duration).test(this.test).type(this.type).coefficient(this.coefficient);
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public RegressionTestSpec getTest() {
        return this.test;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Parameter getCoefficient() {
        return this.coefficient;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EasterSpec)) {
            return false;
        }
        EasterSpec other = (EasterSpec)o;
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        RegressionTestSpec this$test = this.getTest();
        RegressionTestSpec other$test = other.getTest();
        if (this$test == null ? other$test != null : !((Object)((Object)this$test)).equals((Object)other$test)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Parameter this$coefficient = this.getCoefficient();
        Parameter other$coefficient = other.getCoefficient();
        return !(this$coefficient == null ? other$coefficient != null : !this$coefficient.equals(other$coefficient));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDuration();
        RegressionTestSpec $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : ((Object)((Object)$test)).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Parameter $coefficient = this.getCoefficient();
        result = result * 59 + ($coefficient == null ? 43 : $coefficient.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "EasterSpec(duration=" + this.getDuration() + ", test=" + String.valueOf((Object)this.getTest()) + ", type=" + String.valueOf((Object)this.getType()) + ", coefficient=" + String.valueOf(this.getCoefficient()) + ")";
    }

    public static enum Type {
        Unused,
        Easter,
        JulianEaster,
        SCEaster;

    }

    public static class Builder
    implements Validatable.Builder<EasterSpec> {
        @Generated
        private int duration;
        @Generated
        private RegressionTestSpec test;
        @Generated
        private Type type;
        @Generated
        private Parameter coefficient;

        public Builder easterSpec(boolean preTest) {
            return this.easterSpec(preTest, false);
        }

        public Builder easterSpec(boolean preTest, boolean julian) {
            this.test = RegressionTestSpec.Add;
            this.type = julian ? Type.JulianEaster : Type.Easter;
            this.duration = 8;
            this.test = preTest ? RegressionTestSpec.Add : RegressionTestSpec.None;
            return this;
        }

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        @Generated
        public @NonNull Builder test(RegressionTestSpec test) {
            this.test = test;
            return this;
        }

        @Generated
        public @NonNull Builder type(Type type) {
            this.type = type;
            return this;
        }

        @Generated
        public @NonNull Builder coefficient(Parameter coefficient) {
            this.coefficient = coefficient;
            return this;
        }

        @Generated
        public @NonNull EasterSpec buildWithoutValidation() {
            return new EasterSpec(this.duration, this.test, this.type, this.coefficient);
        }

        @Generated
        public @NonNull String toString() {
            return "EasterSpec.Builder(duration=" + this.duration + ", test=" + String.valueOf((Object)this.test) + ", type=" + String.valueOf((Object)this.type) + ", coefficient=" + String.valueOf(this.coefficient) + ")";
        }
    }
}

