/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramoseats;

import jdplus.sa.base.api.SaSpecification;
import jdplus.sa.base.api.benchmarking.SaBenchmarkingSpec;
import jdplus.toolkit.base.api.processing.AlgorithmDescriptor;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.tramoseats.base.api.seats.DecompositionSpec;
import jdplus.tramoseats.base.api.tramo.TramoSpec;
import jdplus.tramoseats.base.api.tramoseats.TramoSeatsException;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TramoSeatsSpec
implements Validatable<TramoSeatsSpec>,
SaSpecification {
    public static final String METHOD = "tramoseats";
    public static final String VERSION_LEGACY = "0.1.0.0";
    public static final String VERSION_V3 = "3.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR_LEGACY = new AlgorithmDescriptor("Seasonal adjustment", "tramoseats", "0.1.0.0");
    public static final AlgorithmDescriptor DESCRIPTOR_V3 = new AlgorithmDescriptor("Seasonal adjustment", "tramoseats", "3.0.0");
    public static final TramoSeatsSpec DEFAULT;
    @NonNull
    private final TramoSpec tramo;
    @NonNull
    private final DecompositionSpec seats;
    @NonNull
    private final SaBenchmarkingSpec benchmarking;
    public static final TramoSeatsSpec RSA0;
    public static final TramoSeatsSpec RSA1;
    public static final TramoSeatsSpec RSA2;
    public static final TramoSeatsSpec RSA3;
    public static final TramoSeatsSpec RSA4;
    public static final TramoSeatsSpec RSA5;
    public static final TramoSeatsSpec RSAfull;
    private static final String SMETHOD = "TS";

    public AlgorithmDescriptor getAlgorithmDescriptor() {
        return DESCRIPTOR_V3;
    }

    public TramoSeatsSpec validate() throws IllegalArgumentException {
        this.tramo.validate();
        this.seats.validate();
        this.benchmarking.validate();
        return this;
    }

    public static Builder builder() {
        return new Builder().tramo(TramoSpec.DEFAULT).seats(DecompositionSpec.DEFAULT).benchmarking(SaBenchmarkingSpec.DEFAULT_DISABLED);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    public static final TramoSeatsSpec[] allSpecifications() {
        return new TramoSeatsSpec[]{RSA0, RSA1, RSA2, RSA3, RSA4, RSA5, RSAfull};
    }

    public static TramoSeatsSpec fromString(String name) {
        switch (name) {
            case "RSA0": 
            case "rsa0": {
                return RSA0;
            }
            case "RSA1": 
            case "rsa1": {
                return RSA1;
            }
            case "RSA2": 
            case "rsa2": {
                return RSA2;
            }
            case "RSA3": 
            case "rsa3": {
                return RSA3;
            }
            case "RSA4": 
            case "rsa4": {
                return RSA4;
            }
            case "RSA5": 
            case "rsa5": {
                return RSA5;
            }
            case "RSAfull": 
            case "rsafull": {
                return RSAfull;
            }
        }
        throw new TramoSeatsException();
    }

    public String display() {
        if (this == RSA0) {
            return "RSA0";
        }
        if (this == RSA1) {
            return "RSA1";
        }
        if (this == RSA2) {
            return "RSA2";
        }
        if (this == RSA3) {
            return "RSA3";
        }
        if (this == RSA4) {
            return "RSA4";
        }
        if (this == RSA5) {
            return "RSA5";
        }
        if (this == RSAfull) {
            return "RSAfull";
        }
        if (this.equals(RSA0)) {
            return "RSA0";
        }
        if (this.equals(RSA1)) {
            return "RSA1";
        }
        if (this.equals(RSA2)) {
            return "RSA2";
        }
        if (this.equals(RSA3)) {
            return "RSA3";
        }
        if (this.equals(RSA4)) {
            return "RSA4";
        }
        if (this.equals(RSA5)) {
            return "RSA5";
        }
        if (this.equals(RSAfull)) {
            return "RSAfull";
        }
        return SMETHOD;
    }

    @Generated
    TramoSeatsSpec(@NonNull TramoSpec tramo, @NonNull DecompositionSpec seats, @NonNull SaBenchmarkingSpec benchmarking) {
        if (tramo == null) {
            throw new NullPointerException("tramo is marked non-null but is null");
        }
        if (seats == null) {
            throw new NullPointerException("seats is marked non-null but is null");
        }
        if (benchmarking == null) {
            throw new NullPointerException("benchmarking is marked non-null but is null");
        }
        this.tramo = tramo;
        this.seats = seats;
        this.benchmarking = benchmarking;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().tramo(this.tramo).seats(this.seats).benchmarking(this.benchmarking);
    }

    @NonNull
    @Generated
    public TramoSpec getTramo() {
        return this.tramo;
    }

    @NonNull
    @Generated
    public DecompositionSpec getSeats() {
        return this.seats;
    }

    @NonNull
    @Generated
    public SaBenchmarkingSpec getBenchmarking() {
        return this.benchmarking;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TramoSeatsSpec)) {
            return false;
        }
        TramoSeatsSpec other = (TramoSeatsSpec)o;
        TramoSpec this$tramo = this.getTramo();
        TramoSpec other$tramo = other.getTramo();
        if (this$tramo == null ? other$tramo != null : !((Object)this$tramo).equals(other$tramo)) {
            return false;
        }
        DecompositionSpec this$seats = this.getSeats();
        DecompositionSpec other$seats = other.getSeats();
        if (this$seats == null ? other$seats != null : !((Object)this$seats).equals(other$seats)) {
            return false;
        }
        SaBenchmarkingSpec this$benchmarking = this.getBenchmarking();
        SaBenchmarkingSpec other$benchmarking = other.getBenchmarking();
        return !(this$benchmarking == null ? other$benchmarking != null : !this$benchmarking.equals(other$benchmarking));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TramoSpec $tramo = this.getTramo();
        result = result * 59 + ($tramo == null ? 43 : ((Object)$tramo).hashCode());
        DecompositionSpec $seats = this.getSeats();
        result = result * 59 + ($seats == null ? 43 : ((Object)$seats).hashCode());
        SaBenchmarkingSpec $benchmarking = this.getBenchmarking();
        result = result * 59 + ($benchmarking == null ? 43 : $benchmarking.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "TramoSeatsSpec(tramo=" + String.valueOf(this.getTramo()) + ", seats=" + String.valueOf(this.getSeats()) + ", benchmarking=" + String.valueOf(this.getBenchmarking()) + ")";
    }

    static {
        RSA0 = DEFAULT = (TramoSeatsSpec)TramoSeatsSpec.builder().build();
        RSA1 = (TramoSeatsSpec)TramoSeatsSpec.builder().tramo(TramoSpec.TR1).seats(DecompositionSpec.DEFAULT).build();
        RSA2 = (TramoSeatsSpec)TramoSeatsSpec.builder().tramo(TramoSpec.TR2).seats(DecompositionSpec.DEFAULT).build();
        RSA3 = (TramoSeatsSpec)TramoSeatsSpec.builder().tramo(TramoSpec.TR3).seats(DecompositionSpec.DEFAULT).build();
        RSA4 = (TramoSeatsSpec)TramoSeatsSpec.builder().tramo(TramoSpec.TR4).seats(DecompositionSpec.DEFAULT).build();
        RSA5 = (TramoSeatsSpec)TramoSeatsSpec.builder().tramo(TramoSpec.TR5).seats(DecompositionSpec.DEFAULT).build();
        RSAfull = (TramoSeatsSpec)TramoSeatsSpec.builder().tramo(TramoSpec.TRfull).seats(DecompositionSpec.DEFAULT).build();
    }

    public static class Builder
    implements Validatable.Builder<TramoSeatsSpec> {
        @Generated
        private TramoSpec tramo;
        @Generated
        private DecompositionSpec seats;
        @Generated
        private SaBenchmarkingSpec benchmarking;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder tramo(@NonNull TramoSpec tramo) {
            if (tramo == null) {
                throw new NullPointerException("tramo is marked non-null but is null");
            }
            this.tramo = tramo;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder seats(@NonNull DecompositionSpec seats) {
            if (seats == null) {
                throw new NullPointerException("seats is marked non-null but is null");
            }
            this.seats = seats;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder benchmarking(@NonNull SaBenchmarkingSpec benchmarking) {
            if (benchmarking == null) {
                throw new NullPointerException("benchmarking is marked non-null but is null");
            }
            this.benchmarking = benchmarking;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull TramoSeatsSpec buildWithoutValidation() {
            return new TramoSeatsSpec(this.tramo, this.seats, this.benchmarking);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "TramoSeatsSpec.Builder(tramo=" + String.valueOf(this.tramo) + ", seats=" + String.valueOf(this.seats) + ", benchmarking=" + String.valueOf(this.benchmarking) + ")";
        }
    }
}

