/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramo;

import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class OutlierSpec
implements Validatable<OutlierSpec> {
    public static final double DEF_DELTATC = 0.7;
    public static final boolean DEF_EML = false;
    public static final OutlierSpec DEFAULT_DISABLED = (OutlierSpec)OutlierSpec.builder().build();
    public static final OutlierSpec DEFAULT_ENABLED = (OutlierSpec)OutlierSpec.builder().ao(true).ls(true).tc(true).build();
    private final boolean ao;
    private final boolean ls;
    private final boolean tc;
    private final boolean so;
    private final double deltaTC;
    private final boolean maximumLikelihood;
    private final double criticalValue;
    @NonNull
    private final TimeSelector span;

    public static Builder builder() {
        return new Builder().deltaTC(0.7).maximumLikelihood(false).criticalValue(0.0).span(TimeSelector.all());
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_DISABLED);
    }

    public boolean isUsed() {
        return this.ao || this.ls || this.tc || this.so;
    }

    public OutlierSpec validate() throws IllegalArgumentException {
        if (this.deltaTC != 0.0 && this.deltaTC < 0.3 || this.deltaTC >= 1.0) {
            throw new IllegalArgumentException("TC should belong to [0.3, 1.0[");
        }
        if (this.criticalValue != 0.0 && this.criticalValue < 2.0) {
            throw new IllegalArgumentException("Critical value should be greater than 2.0");
        }
        return this;
    }

    @Generated
    OutlierSpec(boolean ao, boolean ls, boolean tc, boolean so, double deltaTC, boolean maximumLikelihood, double criticalValue, @NonNull TimeSelector span) {
        if (span == null) {
            throw new NullPointerException("span is marked non-null but is null");
        }
        this.ao = ao;
        this.ls = ls;
        this.tc = tc;
        this.so = so;
        this.deltaTC = deltaTC;
        this.maximumLikelihood = maximumLikelihood;
        this.criticalValue = criticalValue;
        this.span = span;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().ao(this.ao).ls(this.ls).tc(this.tc).so(this.so).deltaTC(this.deltaTC).maximumLikelihood(this.maximumLikelihood).criticalValue(this.criticalValue).span(this.span);
    }

    @Generated
    public boolean isAo() {
        return this.ao;
    }

    @Generated
    public boolean isLs() {
        return this.ls;
    }

    @Generated
    public boolean isTc() {
        return this.tc;
    }

    @Generated
    public boolean isSo() {
        return this.so;
    }

    @Generated
    public double getDeltaTC() {
        return this.deltaTC;
    }

    @Generated
    public boolean isMaximumLikelihood() {
        return this.maximumLikelihood;
    }

    @Generated
    public double getCriticalValue() {
        return this.criticalValue;
    }

    @NonNull
    @Generated
    public TimeSelector getSpan() {
        return this.span;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutlierSpec)) {
            return false;
        }
        OutlierSpec other = (OutlierSpec)o;
        if (this.isAo() != other.isAo()) {
            return false;
        }
        if (this.isLs() != other.isLs()) {
            return false;
        }
        if (this.isTc() != other.isTc()) {
            return false;
        }
        if (this.isSo() != other.isSo()) {
            return false;
        }
        if (Double.compare(this.getDeltaTC(), other.getDeltaTC()) != 0) {
            return false;
        }
        if (this.isMaximumLikelihood() != other.isMaximumLikelihood()) {
            return false;
        }
        if (Double.compare(this.getCriticalValue(), other.getCriticalValue()) != 0) {
            return false;
        }
        TimeSelector this$span = this.getSpan();
        TimeSelector other$span = other.getSpan();
        return !(this$span == null ? other$span != null : !this$span.equals(other$span));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAo() ? 79 : 97);
        result = result * 59 + (this.isLs() ? 79 : 97);
        result = result * 59 + (this.isTc() ? 79 : 97);
        result = result * 59 + (this.isSo() ? 79 : 97);
        long $deltaTC = Double.doubleToLongBits(this.getDeltaTC());
        result = result * 59 + (int)($deltaTC >>> 32 ^ $deltaTC);
        result = result * 59 + (this.isMaximumLikelihood() ? 79 : 97);
        long $criticalValue = Double.doubleToLongBits(this.getCriticalValue());
        result = result * 59 + (int)($criticalValue >>> 32 ^ $criticalValue);
        TimeSelector $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : $span.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "OutlierSpec(ao=" + this.isAo() + ", ls=" + this.isLs() + ", tc=" + this.isTc() + ", so=" + this.isSo() + ", deltaTC=" + this.getDeltaTC() + ", maximumLikelihood=" + this.isMaximumLikelihood() + ", criticalValue=" + this.getCriticalValue() + ", span=" + String.valueOf(this.getSpan()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<OutlierSpec> {
        @Generated
        private boolean ao;
        @Generated
        private boolean ls;
        @Generated
        private boolean tc;
        @Generated
        private boolean so;
        @Generated
        private double deltaTC;
        @Generated
        private boolean maximumLikelihood;
        @Generated
        private double criticalValue;
        @Generated
        private TimeSelector span;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ao(boolean ao) {
            this.ao = ao;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ls(boolean ls) {
            this.ls = ls;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder tc(boolean tc) {
            this.tc = tc;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder so(boolean so) {
            this.so = so;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder deltaTC(double deltaTC) {
            this.deltaTC = deltaTC;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder maximumLikelihood(boolean maximumLikelihood) {
            this.maximumLikelihood = maximumLikelihood;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder criticalValue(double criticalValue) {
            this.criticalValue = criticalValue;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder span(@NonNull TimeSelector span) {
            if (span == null) {
                throw new NullPointerException("span is marked non-null but is null");
            }
            this.span = span;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull OutlierSpec buildWithoutValidation() {
            return new OutlierSpec(this.ao, this.ls, this.tc, this.so, this.deltaTC, this.maximumLikelihood, this.criticalValue, this.span);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "OutlierSpec.Builder(ao=" + this.ao + ", ls=" + this.ls + ", tc=" + this.tc + ", so=" + this.so + ", deltaTC=" + this.deltaTC + ", maximumLikelihood=" + this.maximumLikelihood + ", criticalValue=" + this.criticalValue + ", span=" + String.valueOf(this.span) + ")";
        }
    }
}

