% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_regular.R
\name{ljungbox}
\alias{ljungbox}
\title{Ljung-Box Test}
\usage{
ljungbox(data, k = 1, lag = 1, nhp = 0, sign = 0, mean = TRUE)
}
\arguments{
\item{data}{data being tested.}

\item{k}{number of auto-correlations used in the test}

\item{lag}{number of lags used between two auto-correlations.}

\item{nhp}{number of hyper parameters (to correct the degree of freedom)}

\item{sign}{if \code{sign = 1}, only positive auto-correlations are considered in the test.
If \code{sign = -1}, only negative auto-correlations are considered.
If \code{sign = 0}, all auto-correlations are integrated in the test.}

\item{mean}{Mean correction. If \code{TRUE}, the auto-correlations are computed as usual.
If \code{FALSE}, we consider that the (known) mean is 0 and that the series has been corrected for it.}
}
\value{
A \code{c("JD3_TEST", "JD3")} object (see \code{\link[=statisticaltest]{statisticaltest()}} for details).
}
\description{
Compute Ljung-Box test to check the independence of a data.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
ljungbox(random_t(2, 100), lag = 24, k = 1)
ljungbox(ABS$X0.2.09.10.M, lag = 24, k = 1)
\dontshow{\}) # examplesIf}
}
