/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.advanced.dstats;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.api.advanced.dstats.Distributions;

public final class DistributionsLoader {

    public static final class Processor {
        private final Iterable<Distributions.Processor> source = ServiceLoader.load(Distributions.Processor.class);
        private final AtomicReference<Distributions.Processor> resource = new AtomicReference<Distributions.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private Distributions.Processor doLoad() throws IllegalStateException {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseThrow(() -> new IllegalStateException("Missing mandatory provider of Distributions.Processor"));
        }

        public Distributions.Processor get() {
            return this.resource.get();
        }

        public void set(Distributions.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() throws IllegalStateException {
            Iterable<Distributions.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() throws IllegalStateException {
            Iterable<Distributions.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

