% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jd3xml.R
\name{xml_data}
\alias{xml_data}
\title{Retrieves all the time series in a specified collection from an xml file.}
\usage{
xml_data(file, collection = 1, charset = NULL, fullNames = FALSE)
}
\arguments{
\item{file}{The xml file.}

\item{collection}{The name or the 1-based position of the collection containing the requested data.}

\item{charset}{The character set used in the file}

\item{fullNames}{Specifies if full names (containing the name of the sheet and the name of the series) are used or not.}
}
\value{
A ts collection with all the series.
}
\description{
Retrieves all the time series in a specified collection from an xml file.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
\donttest{
set_xml_paths(system.file("extdata", package = "rjd3providers"))
xml_1 <- xml_data("Prod.xml", 1, charset = "iso-8859-1")
xml_all <- xml_data("Prod.xml", "industrial production", charset = "iso-8859-1")
}
\dontshow{\}) # examplesIf}
}
