/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.io.IOException;
import java.util.Objects;
import standalone_spreadsheet.org.dhatim.fastexcel.Writer;

class Alignment {
    private final String horizontal;
    private final String vertical;
    private final boolean wrapText;
    private final int rotation;
    private final int indent;

    Alignment(String horizontal, String vertical, boolean wrapText, int rotation, int indent) {
        this.horizontal = horizontal;
        this.vertical = vertical;
        this.wrapText = wrapText;
        this.rotation = rotation;
        this.indent = indent;
    }

    public int hashCode() {
        return Objects.hash(this.horizontal, this.vertical, this.wrapText);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            Alignment other = (Alignment)obj;
            result = Objects.equals(this.horizontal, other.horizontal) && Objects.equals(this.vertical, other.vertical) && Objects.equals(this.wrapText, other.wrapText) && Objects.equals(this.rotation, other.rotation) && Objects.equals(this.indent, other.indent);
        } else {
            result = false;
        }
        return result;
    }

    void write(Writer w) throws IOException {
        w.append("<alignment");
        if (this.horizontal != null) {
            w.append(" horizontal=\"").append(this.horizontal).append('\"');
        }
        if (this.vertical != null) {
            w.append(" vertical=\"").append(this.vertical).append('\"');
        }
        if (this.rotation != 0) {
            w.append(" textRotation=\"").append(this.rotation).append('\"');
        }
        if (this.indent != 0) {
            w.append(" indent=\"").append(this.indent).append('\"');
        }
        if (this.wrapText) {
            w.append(" wrapText=\"true\"");
        }
        w.append("/>");
    }
}

