% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cls.R
\name{write_factor}
\alias{write_factor}
\alias{write_cls}
\title{Write a factor in the CLS format}
\usage{
write_factor(fac, con = stdout(), offset = 0, sep = c("\\t", " "))

write_cls(fac, con = stdout(), offset = 0, sep = c("\\t", " "))
}
\arguments{
\item{fac}{A factor}

\item{con}{Connection to write to}

\item{offset}{he integer representing the first level, default is set to 0, for some software it can be set to 1}

\item{sep}{Separator used in the CLS format, can be '\\t' (recommended) or ' ' (not to be used when space exists in levels)}
}
\value{
No return value, called for side effects (writes to connection).
}
\description{
Write a factor in the CLS format
}
\note{
The original CLS format specifies that both tab or space can be used as separators.
This makes it unable to represent factors with sapces in levels. In order to accomodate
CLS format for these factors, we propose using tab as separators in CLS files when encoding factors
in R. The default setting of \code{read_factor} and \code{write_factor} uses tab.
}
\examples{
set.seed(1887)
tempfac <- factor(sample(LETTERS, 30, replace=TRUE), levels=sample(LETTERS))
tempfile <- tempfile()
write_factor(tempfac, tempfile)
readLines(tempfile)
stopifnot(identical(tempfac, read_factor(tempfile)))
}
\seealso{
\code{\link{read_factor}}
}
