% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argparse.R
\name{argParse}
\alias{argParse}
\alias{argPresent}
\title{Parser of command-line parameters in BIOS style}
\usage{
argParse(optargs, reqargs, usage = paste(scriptName(), "-h"), strict = TRUE)

argPresent(opt)
}
\arguments{
\item{optargs}{String describing optional arguments. Syntax: \code{<optname1>[,paramcnt1] <optname2>[,paramcnt2]\dots}. Example: \dQuote{verbose outfile,1} means the command line has the syntax \code{prog [-verbose] [outfile name]}. It can be an empty string to express \dQuote{no options}. The value for \code{paramcnt} is 0.}

\item{reqargs}{String describining required arguments. Syntax: \code{<argname1> <argname2>\dots}. Example: \dQuote{infile outfile} means the command line has the syntax \code{prog [-infile ]infile [-outfile ]coutfile}. Even if it is empty, it is checked that at least one non-optional value is given.}

\item{usage}{A character string to be printed if the command-line option parsing fails}

\item{strict}{Logical, are extra un-prefixed parameters allowed? If set to \code{TRUE}, the un-prefixed parameters (which must be at the end of the command line) will be returned as a character vector.}

\item{opt}{Character string, option name}
}
\value{
\code{argParse} is used for the side effects. If \code{strict} is set to
\code{TRUE}, an invisible \code{NULL} is returned; otherwise, extra
un-prefixed parameters are returned as an invisible character vector 

\code{argGet} and \code{argGetPos} returns a character
string. \code{argPresent} returns a boolean value.

In case of any error (wrong syntax, or not-existing option) the R
session quits while printing the error message.
}
\description{
Parser of command-line parameters in BIOS style

Test whether the given option is present in the command line or not
}
\details{
\code{argParse} must be called before \code{argGet},\code{argGetPos}
  , \code{argPresent}, or \code{argGetDefault}. It checks whether the command line syntax agrees
  with the specification of \code{optargs} and \code{reqargs}. If not,
  the \code{usage} message is printed and the program exists.

  \code{argPresent} returns a boolean value indicating whether the option is present or not.
  
  If the syntax was found correct, \code{argGetPos} can be called to
  fetch the \code{ind}th value of the option \code{opt} (indexing from 1). For instance,
  if the following option \code{-ranges 3 5} is defined,
  argGetPos(\dQuote{range}, 2) returns \code{5}. \code{argGet} is
  a shortcut to fetch the first element. If the opt is missing, the
  \code{default} value will be returned.
}
\examples{
\donttest{
argParse("verbose threshold,2", "infile outfile",
         usage="prog [-infile ]infile [-outfile ]outfile [-verbose] [-threshold MIN MAX]")
argIsInit()
argPresent("verbose")
}

}
