% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argparse.R
\name{argGetPos}
\alias{argGetPos}
\title{Parse an argument with the given position}
\usage{
argGetPos(opt, ind = 1L, default = NULL, choices = NULL)
}
\arguments{
\item{opt}{name of the argument to be parsed}

\item{ind}{index of the argument to be parsed, starting from 1.}

\item{default}{default values to be returned if the argument is not provided}

\item{choices}{a character vector of accepted values; if a string outside the vector is provided, the function will stop and print error message}
}
\value{
A character string representing the value of the argument
}
\description{
Get the value of an named argument with the given position
}
\details{
The parsing is performed at C-level. If the argument accepts only one value, users can also call argGet(opt, default=NULL, choices=NULL)
}
\examples{
\donttest{argGetPos("thresholds", ind=2)}

}
\seealso{
\code{\link{argParse}}, \code{\link{argGet}}, and \code{\link{argPresent}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
