% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_spec.r
\name{set_margins}
\alias{set_margins}
\title{Set page margins}
\usage{
set_margins(x, top = NULL, bottom = NULL, left = NULL, right = NULL)
}
\arguments{
\item{x}{The report spec object.}

\item{top}{The top margin.}

\item{bottom}{The bottom margin.}

\item{left}{The left margin.}

\item{right}{The right margin.}
}
\value{
The report_spec with margins set as desired.
}
\description{
Sets the page margins for the report.  The units for this 
parameter can be inches or centimeters, depending on the units of measure 
specified on the \code{\link{create_report}} function.
}
\details{
The margins set with \code{set_margins} will be used for the entire report.  
Units for the margins
are specified by the \code{units} parameter on the 
\code{\link{create_report}} function.  Available units are 'inches' and 'cm'.
When the unit of measure is inches, default margins are 1 inch on the left and 
right, and .5 inches on top and bottom.  When the unit of measure is 
centimeters, default margins are 2.54 cm on left and right, and 1.27 cm
on top and bottom.

Note that when using output type of TXT, and not using the 
\code{blank_margins} option, setting the margins only reduces
the area available for content on a page.  You must still set the actual
margins on the available editor to match those specified in 
\code{set_margins}.  Any mismatch may result in content not fitting properly
on the page. For best results, set the right and bottom margins to zero 
to allow for slight overflow without causing a page break or wrapping lines.
}
\examples{
library(reporter)
library(magrittr)

# Create a temporary file
tmp <- file.path(tempdir(), "bod.txt")

# Define table
tbl <- create_table(BOD, width = 2.5) \%>\% 
  titles("Table 3.6", "BOD¹ Sample Report") \%>\% 
  define(Time, format = "Day \%s", align = "left") \%>\% 
  define(demand, format = "\%2.1f mg/l", label = "Demand") \%>\% 
  footnotes("¹ Biochemical Oxygen Demand")
       
# Define report #1 - No blank margins
rpt <- create_report(tmp, orientation="portrait") \%>\%
  add_content(tbl, align = "left") 

# Write the report
write_report(rpt)

# Write report to console
writeLines(readLines(tmp, encoding = "UTF-8"))

#           Table 3.6
#       BOD* Sample Report
# 
# Time                  Demand
# ----------------------------
# Day 1               8.3 mg/l
# Day 2              10.3 mg/l
# Day 3              19.0 mg/l
# Day 4              16.0 mg/l
# Day 5              15.6 mg/l
# Day 7              19.8 mg/l
# 
# * Biochemical Oxygen Demand


# Define report #2 - blank margins
rpt <- create_report(tmp, orientation="portrait") \%>\%
  options_fixed(blank_margins = TRUE) \%>\% 
  set_margins(top = .5, left = 1) \%>\% 
  add_content(tbl, align = "left") 

# Write the report
write_report(rpt)

# Write report to console
writeLines(readLines(tmp, encoding = "UTF-8"))

# 
# 
# 
#                       Table 3.6
#                   BOD* Sample Report
# 
#              Time                  Demand
#              ----------------------------
#              Day 1               8.3 mg/l
#              Day 2              10.3 mg/l
#              Day 3              19.0 mg/l
#              Day 4              16.0 mg/l
#              Day 5              15.6 mg/l
#              Day 7              19.8 mg/l
# 
#              * Biochemical Oxygen Demand
}
\seealso{
Other report: 
\code{\link{add_content}()},
\code{\link{create_report}()},
\code{\link{footer_image}()},
\code{\link{footnotes}()},
\code{\link{header_image}()},
\code{\link{options_fixed}()},
\code{\link{page_by}()},
\code{\link{page_footer}()},
\code{\link{page_header}()},
\code{\link{print.report_spec}()},
\code{\link{title_header}()},
\code{\link{titles}()},
\code{\link{write_report}()}
}
\concept{report}
