% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rdbms.R
\name{read_rdbms}
\alias{read_rdbms}
\title{Import data from relational database management systems (RDBMS).}
\usage{
read_rdbms(login, query)
}
\arguments{
\item{login}{The connection object obtained from the \code{login()} function.}

\item{query}{An SQL query or a list with the following elements:
\enumerate{
\item table: a string with the table name
\item fields: a vector of column names. When specified, only
those columns will be returned. Default is \code{NULL}.
\item filter: an expression or a vector of values used to filter the
rows from the table of interest. This should be of the same length
as the value for the 'select'. Default is \code{NULL}.
}}
}
\value{
A \code{data.frame} with the requested data as specified in the \code{query}
argument.
}
\description{
The function assumes the user has read access to the database.
Importing data from RDBMS requires the installation of the appropriate
\code{driver} that is compatible with the server version hosting the database.
For more details, see the
\href{../articles/install_drivers.html}{Installing drivers} on
how to install the driver.
}
\examples{
\dontrun{
  # establish the connection to the database
  rdbms_login <- login(
    from = "mysql-rfam-public.ebi.ac.uk",
    type = "mysql",
    user_name = "rfamro",
    password = "",
    driver_name = "",
    db_name = "Rfam",
    port = 4497
  )

  # import data where query parameters are specified as a list
  authors_list <- read_rdbms(
    login = rdbms_login,
    query = list(table = "author", fields = NULL, filter = NULL)
  )

  # import data where query parameters is within an SQL query
  authors_list <- read_rdbms(
    login = rdbms_login,
    query = "select * from author"
  )
}
}
