% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.R
\name{describe_draws}
\alias{describe_draws}
\title{Describe an rbmi Draws Object}
\usage{
describe_draws(draws_obj)
}
\arguments{
\item{draws_obj}{A \code{draws} object returned by \code{\link[rbmi:draws]{rbmi::draws()}}.}
}
\value{
An S3 object of class \code{c("describe_draws", "list")} containing:
\describe{
\item{method}{Human-readable method name (e.g., "Bayesian (MCMC via Stan)")}
\item{method_class}{Raw class name: "bayes", "approxbayes", or "condmean"}
\item{n_samples}{Total number of samples}
\item{n_failures}{Number of failed samples}
\item{formula}{Deparsed model formula string}
\item{covariance}{Covariance structure (e.g., "us")}
\item{same_cov}{Logical; whether same covariance is used across groups}
\item{condmean_type}{(condmean only) "jackknife" or "bootstrap"}
\item{n_primary}{(condmean only) Always 1}
\item{n_resampled}{(condmean only) Number of resampled draws}
\item{bayes_control}{(bayes only) List with warmup, thin, chains, seed}
\item{mcmc}{(bayes with stanfit only) List with rhat, ess, max_rhat,
min_ess, n_params, converged}
}
}
\description{
Extracts structured metadata from an rbmi draws object, including method,
formula, sample count, failures, covariance structure, and (for Bayesian
methods) MCMC convergence diagnostics. Returns an S3 object with an
informative \code{\link[=print]{print()}} method.
}
\details{
For conditional mean methods, the sample count is displayed as "1 + N"
matching the rbmi convention where the first sample is the primary (full-data)
fit and the remaining N are jackknife or bootstrap resamples.

For Bayesian methods, MCMC convergence diagnostics (ESS, Rhat) are extracted
from the \code{stanfit} object when \code{rstan} is available. The \code{converged} flag
uses the Rhat < 1.1 threshold matching rbmi's own convention.
}
\examples{
\dontrun{
library(rbmi)
library(dplyr)
data("ADEFF", package = "rbmiUtils")

# Prepare ADEFF data for rbmi pipeline
ADEFF <- ADEFF |>
  mutate(
    TRT = factor(TRT01P, levels = c("Placebo", "Drug A")),
    USUBJID = factor(USUBJID),
    AVISIT = factor(AVISIT, levels = c("Week 24", "Week 48"))
  )

vars <- set_vars(
  subjid = "USUBJID", visit = "AVISIT", group = "TRT",
  outcome = "CHG", covariates = c("BASE", "STRATA", "REGION")
)
dat <- ADEFF |> select(USUBJID, STRATA, REGION, TRT, BASE, CHG, AVISIT)
draws_obj <- draws(
  data = dat, vars = vars,
  method = method_bayes(n_samples = 100)
)

# Inspect the draws object
desc <- describe_draws(draws_obj)
print(desc)

# Programmatic access to metadata
desc$method
desc$n_samples
desc$formula
}

}
\seealso{
\itemize{
\item \code{\link[rbmi:draws]{rbmi::draws()}} to create draws objects
\item \code{\link[rbmi:method]{rbmi::method_condmean()}}, \code{\link[rbmi:method]{rbmi::method_bayes()}}, \code{\link[rbmi:method]{rbmi::method_approxbayes()}}
for method specification
}
}
