% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_helpers.R
\name{create_impid}
\alias{create_impid}
\title{Create IMPID Column for Imputed Datasets}
\usage{
create_impid(imputed_list, id_prefix = "")
}
\arguments{
\item{imputed_list}{A list of data.frames, where each element represents one
imputed dataset.}

\item{id_prefix}{Optional character prefix for IMPID values. Default is empty string.}
}
\value{
A single data.frame with all imputed datasets stacked, with an \code{IMPID}
column identifying the source imputation.
}
\description{
Adds an \code{IMPID} column to a list of imputed datasets, converting them to a
single stacked data.frame suitable for use with \code{\link[=analyse_mi_data]{analyse_mi_data()}}.
}
\details{
This function is useful when you have imputed datasets from a source other than
rbmi (e.g., from mice or another MI package) and want to use them with rbmiUtils
analysis functions.
}
\examples{
# Create example imputed datasets
imp1 <- data.frame(USUBJID = c("S1", "S2"), CHG = c(1.5, 2.5))
imp2 <- data.frame(USUBJID = c("S1", "S2"), CHG = c(1.8, 2.2))
imp3 <- data.frame(USUBJID = c("S1", "S2"), CHG = c(1.6, 2.4))

# Stack with IMPID
stacked <- create_impid(list(imp1, imp2, imp3))
print(stacked)

}
\seealso{
\itemize{
\item \code{\link[=get_imputed_data]{get_imputed_data()}} to extract imputed data from rbmi objects
\item \code{\link[=analyse_mi_data]{analyse_mi_data()}} to analyse stacked imputed data
}
}
