% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rblimp_sim.R
\name{rblimp_sim}
\alias{rblimp_sim}
\title{Simulate data using Blimp}
\usage{
rblimp_sim(
  model,
  n,
  seed,
  define = NULL,
  variables = NULL,
  tmpfolder,
  nopowershell = FALSE
)
}
\arguments{
\item{model}{Character string or vector specifying data generation equations.
Can be specified as a vector: \code{c("x = normal(0, 1)", "y = normal(10, 1)")}
OR as a single string with newlines/semicolons: \code{"x = normal(0, 1); y = normal(10, 1);"}
For multilevel: use named list with arbitrary level names (e.g., \code{list(schools = ..., students = ...)}).
The sample size determines the level hierarchy (largest = level-1, smallest = highest level).}

\item{n}{Sample size. For single-level: integer (e.g., \code{1000}).
For multilevel: named list with sample sizes (e.g., \code{list(students = 1000, schools = 100)}).
Names must match the names used in \code{model} list. Sample sizes must be unique.}

\item{seed}{Random seed for reproducibility.}

\item{define}{Character vector or string of parameter definitions (optional).
Can be \code{c("b0 = 10", "b1 = 0.5")} OR \code{"b0 = 10; b1 = 0.5;"}.}

\item{variables}{Formula or character string specifying which variables to save (optional).
If not specified, all variables from the model are saved.}

\item{tmpfolder}{Character string. Temporary folder path. If not specified, creates one with \code{\link{tempdir}}.}

\item{nopowershell}{Windows only. Uses cmd.exe instead of powershell.}
}
\value{
A data.frame with simulated data. The returned object has two attributes:
\describe{
\item{syntax}{The Blimp syntax used for simulation (blimp_syntax object)}
\item{output}{The raw Blimp output (blimp_out object)}
}
Access these with \code{attr(result, "syntax")} and \code{attr(result, "output")}.
}
\description{
Generate simulated datasets using Blimp's SIMULATE command.
Supports both single-level and multilevel data generation.
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Simple regression: y = 10 + 0.5*x + error
dat <- rblimp_sim(
  model = c(
    "x = normal(0, 1)",
    "y = normal(10 + x*0.5, 1)"
  ),
  n = 1000,
  seed = 10972
)

# Same thing with full quoted syntax
dat <- rblimp_sim(
  model = "x = normal(0, 1);
           y = normal(10 + x*0.5, 1);",
  n = 1000,
  seed = 10972
)

# With parameter definitions
dat <- rblimp_sim(
  model = c(
    "x = normal(0, 1)",
    "y = normal(b0 + b1*x, s2e)"
  ),
  n = 1000,
  define = c("b0 = 10", "b1 = 0.5", "s2e = 1"),
  seed = 10972
)

# Multilevel model
dat <- rblimp_sim(
  model = list(
    schools = c(
      "z = normal(0, 1)",
      "u0 = normal(10 + z*-0.5, 1.0)"
    ),
    students = c(
      "x = normal(0, 1)",
      "y = normal(u0 + x*0.5, 1)"
    )
  ),
  n = list(students = 1000, schools = 100),
  seed = 198723
)

# Access syntax and output
syntax <- attr(dat, "syntax")
print(syntax)

output <- attr(dat, "output")
print(output)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=SIMULATE]{SIMULATE()}} for creating a simulation specification to use with \code{\link[=rblimp]{rblimp()}}
}
